;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/benchmarks/kons/t/kons.t ...         */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Dec 21 15:37:02 1992                          */
;*    Last change :  Tue Mar 16 14:56:54 1993  (serrano)               */
;*                                                                     */
;*    Le test Kons de `Kranz'                                          */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(herald kons)

;(define-local-syntax (repeat n exp wanted)
   `(letrec ((_loop_ (lambda (n)
                        (if (fx= n 1)
                            (if (equal? ,wanted ,exp)
                                (mprint 'ok)
                                (mprint 'error))
                            (begin
                               ,exp
                               (_loop_ (fx- n 1)))))))
       (_loop_ ,n)))

(define-local-syntax (=fx x y)
                `(fx= ,x ,y))

(define-local-syntax (+fx x y)
                `(fx+ ,x ,y))

(define-local-syntax (-fx x y)
                `(fx- ,x ,y))

(define-local-syntax (<fx x y)
                `(fx< ,x ,y))

(define (mprint . v)
   (for-each display v)
   
*---------------------------------------------------------------------*/
;*    kons ...                                                         */
;*---------------------------------------------------------------------*/
(define (kons x y)
   (lambda (key)
      (case key
	 ((car) x)
	 ((cdr) y))))

;*---------------------------------------------------------------------*/
;*    list-of-ones ...                                                 */
;*---------------------------------------------------------------------*/
(define list-of-ones
   (do ((i 100000 (fx- i 1))
	(l '()   (kons 1 l)))
	 ((fx= i 0) l)))

;*---------------------------------------------------------------------*/
;*    kar ...                                                          */
;*---------------------------------------------------------------------*/
(define (kar x)
   (x 'car))

;*---------------------------------------------------------------------*/
;*    kdr ...                                                          */
;*---------------------------------------------------------------------*/
(define (kdr x)
   (x 'cdr))

;*---------------------------------------------------------------------*/
;*    sumlist ...                                                      */
;*---------------------------------------------------------------------*/
(define (sumlist)
   (do ((l list-of-ones (kdr l))
	(sum 0 (fx+ (kar l) sum)))
	 ((null? l) sum)))

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main argv)
   (repeat (string->number (cadr argv))
	   (sumlist)
	   100000))
 
	     
	 

	    
