;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; File:         fread.sch
; Description:  FREAD benchmark
; Author:       Richard Gabriel
; Created:      11-Apr-85
; Modified:     11-Apr-85 20:39:09 (Bob Shaw)
;               24-Jul-87 (Will Clinger)
; Language:     Scheme
; Status:       Public Domain
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 
;;; FREAD -- Benchmark to read from a file.
;;; Requires the existence of FPRINT.TST which is created
;;; by FPRINT.

(herald fread)

(define (fread)
  (call-with-input-file
   "fread/misc/fprint.tst"
    (lambda (stream)
      (read stream)))
      #t)
      
;*---------------------------------------------------------------------*/
;*    Les macros                                                       */
;*---------------------------------------------------------------------*/
(define-local-syntax (repeat n exp wanted)
   `(letrec ((_loop_ (lambda (n)
                        (if (fx= n 1)
                            (if (equal? ,wanted ,exp)
                                (mprint 'ok)
                                (mprint 'error))
                            (begin
                               ,exp
                               (_loop_ (fx- n 1)))))))
       (_loop_ ,n)))

(define-local-syntax (=fx x y)
                `(fx= ,x ,y))

(define-local-syntax (+fx x y)
                `(fx+ ,x ,y))

(define-local-syntax (-fx x y)
                `(fx- ,x ,y))

(define-local-syntax (<fx x y)
                `(fx< ,x ,y))

(define (mprint . v)
   (for-each display v)
   (newline))

;;; call: (fread))
;*---------------------------------------------------------------------*/
;*    Les formes top-level                                             */
;*---------------------------------------------------------------------*/
(define (main argv)
    (repeat (string->number (cadr argv))
	   (fread)
	   #t))
  


 
