(herald fib)

;*---------------------------------------------------------------------*/
;*    Les macros                                                       */
;*---------------------------------------------------------------------*/
(define-local-syntax (repeat n exp wanted)
   `(letrec ((_loop_ (lambda (n)
                        (if (fx= n 1)
                            (if (equal? ,wanted ,exp)
                                (mprint 'ok)
                                (mprint 'error))
                            (begin
                               ,exp
                               (_loop_ (fx- n 1)))))))
       (_loop_ ,n)))

(define-local-syntax (=fx x y)
                `(fx= ,x ,y))

(define-local-syntax (+fx x y)
                `(fx+ ,x ,y))

(define-local-syntax (-fx x y)
                `(fx- ,x ,y))

(define-local-syntax (<fx x y)
                `(fx< ,x ,y))

(define (mprint . v)
   (for-each display v)
   (newline))

(define (fib x)
   (if (fx< x 2)
       1
       (fx+ (fib (fx- x 1)) (fib (fx- x 2)))))

;*---------------------------------------------------------------------*/
;*    Les formes top-level                                             */
;*---------------------------------------------------------------------*/
(define (main argv)
    (repeat (string->number (cadr argv))
	   (fib 30)
	   1346269))
  


