;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; File:         destruct.sch
; Description:  DESTRUCTIVE benchmark from Gabriel tests
; Author:       Bob Shaw, HPLabs/ATC
; Created:      8-Apr-85
; Modified:     10-Apr-85 14:54:12 (Bob Shaw)
;               23-Jul-87 (Will Clinger)
;               22-Jan-88 (Will Clinger)
; Language:     Scheme
; Status:       Public Domain
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 
; append! is no longer a standard Scheme procedure, so it must be defined
; for implementations that don't already have it.

(herald destr)

(;*---------------------------------------------------------------------*/
;*    Les macros                                                       */
;*---------------------------------------------------------------------*/
(define-local-syntax (repeat n exp wanted)
   `(letrec ((_loop_ (lambda (n)
                        (if (fx= n 1)
                            (if (equal? ,wanted ,exp)
                                (mprint 'ok)
                                (mprint 'error))
                            (begin
                               ,exp
                               (_loop_ (fx- n 1)))))))
       (_loop_ ,n)))

(define-local-syntax (=fx x y)
                `(fx= ,x ,y))

(define-local-syntax (+fx x y)
                `(fx+ ,x ,y))

(define-local-syntax (-fx x y)
                `(fx- ,x ,y))

(define-local-syntax (<fx x y)
                `(fx< ,x ,y))

(define (mprint . v)
   (for-each display v)
   (newline))

define (append! x y)
  (if (null? x)
      y
      (do ((a x b)
           (b (cdr x) (cdr b)))
          ((null? b)
           (set-cdr! a y)
           x))))

;;; DESTRU -- Destructive operation benchmark
 
(define (destructive n m)
  (let ((l (do ((i 10 (fx- i 1))
                (a '() (cons '() a)))
               ((fx= i 0) a))))
    (do ((i n (fx- i 1)))
        ((fx= i 0))
      (cond ((null? (car l))
             (do ((l l (cdr l)))
                 ((null? l))
               (or (car l)
                   (set-car! l (cons '() '())))
               (append! (car l)
                      (do ((j m (fx- j 1))
                           (a '() (cons '() a)))
                          ((fx= j 0) a)))))
            (else
             (do ((l1 l (cdr l1))
                  (l2 (cdr l) (cdr l2)))
                 ((null? l2))
               (set-cdr! (do ((j (quotient (length (car l2)) 2) (fx- j 1))
                            (a (car l2) (cdr a)))
                           ((zero? j) a)
                         (set-car! a i))
                       (let ((n (quotient (length (car l1)) 2)))
                         (cond ((fx= n 0) (set-car! l1 '())
                                (car l1))
                               (else
                                (do ((j n (fx- j 1))
                                     (a (car l1) (cdr a)))
                                    ((fx= j 1)
                                     (let ((x (cdr a)))
                                            (set-cdr! a '())
                                          x))
                                  (set-car! a i))))))))))))
 
;;; call:  (destructive 600 50)


;*---------------------------------------------------------------------*/
;*    Les formes top-level                                             */
;*---------------------------------------------------------------------*/
(define (main argv)
    (repeat (string->number (cadr argv))
	    (destructive 600 50)
	    #f))
  
