
(defmacro define (name.args . body)
	  `(defun ,(car name.args)
	      ,(cdr name.args)
	      ,@body))
	      
(defmacro begin body
	  `(progn ,@body))

(defun deriv-aux (a) (list '/ (deriv a) a))

(defun deriv (a)
  (cond 
    ((atom a)
     (cond ((eq a 'x) 1) (t 0)))
    ((eq (car a) '+)	
     (cons '+ (mapcar #'deriv (cdr a))))
    ((eq (car a) '-) 
     (cons '- (mapcar #'deriv 
		      (cdr a))))
    ((eq (car a) '*)
     (list '* 
	   a 
	   (cons '+ (mapcar #'deriv-aux (cdr a)))))
    ((eq (car a) '/)
     (list '- 
	   (list '/ 
		 (deriv (cadr a)) 
		 (caddr a))
	   (list '/ 
		 (cadr a) 
		 (list '*
		       (caddr a)
		       (caddr a)
		       (deriv (caddr a))))))
    (t 'error)))
 
(define (run)
   (letn loop ((i 1000))
	 (if (eq i 0)
	     'done
	     (begin
		(deriv '(+ (* 3 x x) (* a x x) (* b x) 5))
		(deriv '(+ (* 3 x x) (* a x x) (* b x) 5))
		(deriv '(+ (* 3 x x) (* a x x) (* b x) 5))
		(deriv '(+ (* 3 x x) (* a x x) (* b x) 5))
		(deriv '(+ (* 3 x x) (* a x x) (* b x) 5))
		(loop (sub i 1))))))
 
;;; call:  (run)

;*---------------------------------------------------------------------*/
;*    Les formes top-level                                             */
;*---------------------------------------------------------------------*/
(define (main)
   (repeat 10
	   (run)))
