;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/benchmarks/curry/t/curry.t ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Dec 21 15:15:51 1992                          */
;*    Last change :  Sat Mar  6 09:28:05 1993  (serrano)               */
;*                                                                     */
;*    Voir these de Kranz (page 131)                                   */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(herald curry)

;*---------------------------------------------------------------------*/
;*    Les macros                                                       */
;*---------------------------------------------------------------------*/
(define-local-syntax (repeat n exp wanted)
   `(letrec ((_loop_ (lambda (n)
                        (if (fx= n 1)
                            (if (equal? ,wanted ,exp)
                                (mprint 'ok)
                                (mprint 'error))
                            (begin
                               ,exp
                               (_loop_ (fx- n 1)))))))
       (_loop_ ,n)))

(define-local-syntax (=fx x y)
                `(fx= ,x ,y))

(define-local-syntax (+fx x y)
                `(fx+ ,x ,y))

(define-local-syntax (-fx x y)
                `(fx- ,x ,y))

(define-local-syntax (<fx x y)
                `(fx< ,x ,y))

(define (mprint . v)
   (for-each display v)
   (newline))
   
;*---------------------------------------------------------------------*/
;*    c3+ ...                                                          */
;*---------------------------------------------------------------------*/
(define (c3+ x)
   (lambda (y)
      (lambda (z)
	 (fx+ (fx+ x y) z))))

;*---------------------------------------------------------------------*/
;*    3+ ...                                                           */
;*---------------------------------------------------------------------*/
(define (3+ x y z)
   (((c3+ x) y) z))

;*---------------------------------------------------------------------*/
;*    fib3 ...                                                         */
;*---------------------------------------------------------------------*/
(define (fib3 x)
   (let fib3 ((x x))
      (cond
	 ((fx<= x 3) 1)
	 (else (3+ (fib3 (fx- x 1)) (fib3 (fx- x 2)) (fx- x 3))))))

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main argv)
   (repeat (string->number (cadr argv))	
	   (fib3 30)
	   1860468))
