;*---------------------------------------------------------------------*/
;*    .../curry.sc ...                                                 */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Dec 21 15:15:51 1992                          */
;*    Last change :  Sat Mar  6 09:26:41 1993  (serrano)               */
;*                                                                     */
;*    Voir these de Kranz (page 131)                                   */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module curry (main main))
(include "misc/scc.sch")

;*---------------------------------------------------------------------*/
;*    c3+ ...                                                          */
;*---------------------------------------------------------------------*/
(define (c3+ x)
   (lambda (y)
      (lambda (z)
	 (+ (+ x y) z))))

;*---------------------------------------------------------------------*/
;*    _3+ ...                                                          */
;*---------------------------------------------------------------------*/
(define (_3+ x y z)
   (((c3+ x) y) z))

;*---------------------------------------------------------------------*/
;*    fib3 ...                                                         */
;*---------------------------------------------------------------------*/
(define (fib3 x)
   (let fib3 ((x x))
      (cond
	 ((<= x 3) 1)
	 (else (_3+ (fib3 (- x 1)) (fib3 (- x 2)) (- x 3))))))

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main argv)
   (repeat (string->number (cadr argv))
	   (fib3 30)
	   1860468))

