
(herald church)

;*---------------------------------------------------------------------*/
;*    Les macros                                                       */
;*---------------------------------------------------------------------*/
(define-local-syntax (repeat n exp wanted)
   `(letrec ((_loop_ (lambda (n)
                        (if (fx= n 1)
                            (if (equal? ,wanted ,exp)
                                (mprint 'ok)
                                (mprint 'error))
                            (begin
                               ,exp
                               (_loop_ (fx- n 1)))))))
       (_loop_ ,n)))

(define-local-syntax (=fx x y)
                `(fx= ,x ,y))

(define-local-syntax (+fx x y)
                `(fx+ ,x ,y))

(define-local-syntax (-fx x y)
                `(fx- ,x ,y))

(define-local-syntax (<fx x y)
                `(fx< ,x ,y))

(define (mprint . v)
   (for-each display v)
   (newline))
   
;*---------------------------------------------------------------------*/
;*    double ...                                                       */
;*---------------------------------------------------------------------*/
(define double
      (lambda (f)
	 (lambda (x) (f (f x)))))

;*---------------------------------------------------------------------*/
;*    quad ...                                                         */
;*---------------------------------------------------------------------*/
(define quad (double double))

;*---------------------------------------------------------------------*/
;*    oct ...                                                          */
;*---------------------------------------------------------------------*/
(define oct (quad quad))

;*---------------------------------------------------------------------*/
;*    succ ...                                                         */
;*---------------------------------------------------------------------*/
(define succ (lambda (x) (+fx 1 x)))

;*---------------------------------------------------------------------*/
;*    repeat ...                                                       */
;*---------------------------------------------------------------------*/
(define lrepeat
      (lambda (n)
	 (if (fx> n 0)
	     (begin
		(lrepeat (-fx n 1))
		(((double oct) succ) 1))
	     (((double oct) succ) 1))))
	     
;*---------------------------------------------------------------------*/
;*    Les formes top-level                                             */
;*---------------------------------------------------------------------*/
(define (main argv)
    (repeat (string->number (cadr argv))
	   (lrepeat 10)
	   65537))
  
