(herald bool)

;*---------------------------------------------------------------------*/
;*    Les macros                                                       */
;*---------------------------------------------------------------------*/
(define-local-syntax (repeat n exp wanted)
   `(letrec ((_loop_ (lambda (n)
			(if (fx= n 1)	
			    (if (equal? ,wanted ,exp)
				(mprint 'ok)
				(mprint 'error))
			    (begin
			       ,exp
			       (_loop_ (fx- n 1)))))))
       (_loop_ ,n)))

(define-local-syntax (=fx x y)
		`(fx= ,x ,y))

(define-local-syntax (+fx x y)
		`(fx+ ,x ,y))

(define-local-syntax (-fx x y)
		`(fx- ,x ,y))

(define-local-syntax (<fx x y)
		`(fx< ,x ,y))

(define (mprint . v)
   (for-each display v)
   (newline))

;*---------------------------------------------------------------------*/
;*    test                                                             */
;*---------------------------------------------------------------------*/
(define (test x t y z)
   (if (or x t)
       (if (and y z)
	   (not x)
	   (or x y t z))
       #f))

;*---------------------------------------------------------------------*/
;*    Les formes top-level                                             */
;*---------------------------------------------------------------------*/
(define (main argv)
   (repeat (string->number (cadr argv))
	   (letrec ((loop (lambda (i)
			     (if (=fx i 0)
				 (list (test #t #t #t #t)
				       (test #f #t #t #t)
				       (test #f #f #t #t)
				       (test #f #f #f #t)
				       (test #f #f #f #f))
				 (begin
				    (test #t #t #t #t)
				    (test #f #t #t #t)
				    (test #f #f #t #t)
				    (test #f #f #f #t)
				    (test #f #f #f #f)
				    (loop (-fx i 1)))))))
	      (loop 500000))
	   '(#f #t #f #f #f)))
	
