# ----------------------------------------------------------------------------
# Makefile for building AWK-to-C Translator/Driver for WIN32 with Visual C++ 
# (Note: Certain commands exceed DOS's 128 character limit and therefore
#        can only be run on Windows NT)
# ---------------------------------------------------------------------------- 

DEFS = -DMSDOS -DENV_32bit

#DEBUG = -W3 -Zi -Od
DEBUG=

CC=cl
O=.obj

CFLAGS = $(DEFS) $(DEBUG) -Ox -O2 -G5 -ML -TC

LIBS =

 
# Object files definitions

AWKOBJS = main$O eval$O eval2$O builtin$O msg$O iop$O io$O field$O array$O \
	node$O version$O missing$O re$O getopt$O getopt1$O

AWKOBJS_DRIVER = driver$O eval2$O builtin$O msg$O iop$O io$O field$O array$O \
        node$O version$O missing$O re$O getopt$O getopt1$O a2c_cprg$O

OBJ_DOS = getid$O popen$O

GNUOBJS = regex$O dfa$O

AWKOBJS_LIB = driver$O eval2$O builtin$O msg$O iop$O io$O field$O array$O \
        node$O version$O missing$O re$O getopt$O getopt1$O \
        $(GNUOBJS) awktab2$O $(OBJ_DOS)
 
ALLOBJS = $(AWKOBJS) $(GNUOBJS) awktab$O $(OBJ_DOS)

ALLOBJS_DRIVER = $(AWKOBJS_DRIVER) $(GNUOBJS) awktab2$O $(OBJ_DOS)


# Rules and dependencies

.SUFFIXES: $O .c .y

.c$O:
	$(CC) $(CFLAGS) -DGAWK -DHAVE_CONFIG_H -c $<

all: awk2c.exe awk2c.lib 

awk2c.exe: $(ALLOBJS)
	$(CC) -ML -Feawk2c.exe $(ALLOBJS) setargv.obj

driver.exe: $(ALLOBJS_DRIVER)
	$(CC) -ML -Fedriver.exe $(ALLOBJS_DRIVER) setargv.obj

awk2c.lib: $(AWKOBJS_LIB)
	lib /OUT:awk2c.lib $(AWKOBJS_LIB)

$(AWKOBJS) awktab2$O driver$O a2c_cprg$O : awk.h config.h

dfa$O: awk.h config.h dfa.h

regex$O: awk.h config.h regex.h 

main$O driver$O: patchlev.h

getopt$O getopt1$O:	getopt.h

popen$O:	popen.h

# A bug in ndmake requires the following rule
#awktab$O: awk.h awktab.c
#	$(CC) $(CFLAGS) -DGAWK -c awktab.c

#awktab.c: awk.y
#	bison -o $@ awk.y

clean:
	del *.obj 

.PHONY: test
test:
	@echo Both dmake and GNU make require modifications to test/Makefile,
	@echo but here we go...
	cd test && $(MAKE) -k
