/*
 * quit.c
 *
 * By Ross Ridge
 * Public Domain
 *
 * Functions for cleaning up and quitting.
 *
 */

#ifdef __GNUC__
#pragma implementation "quit.h"
#endif

#include "mysc.h"
#include "sysdep.h"

#include <stdarg.h>

#ifdef CONFIG_SCCS_IDS
static char const sccs_id[] = "@(#) MySC quit.c 1.1 93/11/09 17:17:57";
#endif

#ifdef CONFIG_BORLANDC
#ifdef __STDC__
extern "C" char * CDECL strlwr(char *);
#endif
#include <dir.h>
#endif /* CONFIG_BORLANDC */

char const *prg_name = NULL;

#ifdef CONFIG_DECLARE_STRERROR
extern "C" char * CDECL strerror(int err);
#endif

void
set_prg_name(char const *name) {
#ifdef CONFIG_BORLANDC

	static char file[MAXFILE + MAXEXT];
	char ext[MAXEXT];

	fnsplit(name, NULL, NULL, file, ext);
	strlwr(file);
	strlwr(ext);

	if (strcmp(ext, ".exe") != 0 && strcmp(ext, ".com") != 0) {
		strcat(file, ext);
	}
	prg_name = file;

#else /* CONFIG_BORLANDC */

	prg_name = name;

#endif /* CONFIG_BORLANDC */
}

NORETURN
quit(int err, char const *fmt, ...) {
	va_list ap;

	va_start(ap, fmt);

	fflush(stdout);
	cleanup::run_cleanups();

	fflush(stdout);

	putc('\n', stderr);

	if (err == -2) {
		usage();
	}


	if (prg_name != NULL && err != 0) {
		fprintf(stderr, "%s: ", (char const *) prg_name);
	}

	vfprintf(stderr, fmt, ap);

	va_end(ap);

	putc('\n', stderr);

	if (err >= 1) {
#ifdef CONFIG_NO_STRERROR
		if (err <= sys_nerr) {
			fprintf(stderr, "%d - %s\n", err, sys_errlist[err]);
		} else {
			fprintf(stderr, "%d - Unknown error\n", err);
		}
#else
		fprintf(stderr, "%d - %s\n", err, strerror(err));
#endif
	}

	fflush(stderr);

#ifndef CONFIG_NO_ABORT
	if (err == -3) {
		abort();
	}
#endif

#ifndef CONFIG_NO_PIPE
	if (cleanup::in_child()) {
		if (err > 0) {
			_exit(1);
		} else {
			_exit(-err);
		}
	}
#endif

	if (err > 0) {
		exit(1);
	} else {
		exit(-err);
	}
}

NORETURN
nomem() {
	quit(-4, "Out of memory!");
}

NORETURN
assert_failed(char const *file, int line, char const *test) {
	quit(-3, "Assertion failed: %s\nFile: %s  Line: %d", test, file, line);
}


class cleanup *cleanup::head = NULL;
int cleanup::running = 0;
int cleanup::all_disabled = 0;
#ifndef CONFIG_NO_FORK
int cleanup::in_child_flag = 0;
#endif

cleanup::cleanup() {
	next = head;
	head = this;
}

cleanup::~cleanup() {
	class cleanup *p = head;

	if (p == this) {
		head = next;
		return;
	}

	while(p->next != this) {
		p = p->next;
		assert(p != NULL);
	}

	p->next = next;
}		

void
cleanup::run_cleanups() {
	if (running || all_disabled) {
		return;
	}
	running = 1;

	class cleanup *p = head;
	while(p != NULL) {
		p->do_cleanup();
		p = p->next;
	}

	running = 0;
	all_disabled++;
	return;
}

/* Local variables: */
/* mode: c++ */
/* End: */
