#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include "config.h"
#ifdef MSDOS
        #include <conio.h>
#else
        #include <curses.h>
#endif
#include "options.h"
#include "convert.h"
#include "prototypes.h"
#include "color.h"

HTMLConversion Convert;

char *GetCharInput (int type)
{
	char szString[255];

	switch (type)
	{
		case AUTHOR:
			cout << "What is your email address? ";
			gets (szString);
			break;
		case DOCUMENT:
			cout << "What is the name of the document? ";
			gets (szString);
			break;
		case OUTPUT:
			cout << "What do you want output file to be? ";
			gets (szString);
			break;
		case ROUTINE:
			cout << "What do you want to call the routine? ";
			gets (szString);
			break;
		case METHOD:
			cout << "Which method do you want to use?" << endl;
			cout << "1] GET" << endl;
			cout << "2] POST" << endl;
			cout << endl << ":] ";
			switch (hotk())
			{
				case '1':
					strcpy (szString , "GET");
					break;
				case '2':
					strcpy (szString , "POST");
					break;
				default:
                                        szString[0] = '\0';
					break;
			}
			break;
		case PROGRAMNAME:
			cout << "What do you want to call the CGI Program? ";
			gets (szString);
			break;
		case DATADIRECTORY:
			cout << "Where is your CGI Data Directory?" << endl << "> ";
			gets (szString);
			break;
		default:
			break;
	}
        return szString;
}

int process_ini ()
{

	FILE *iniFile;

	if (!(iniFile = fopen ( "html2cpp.ini", "r" )))
	{	
		cout << "html2cpp.ini is missing or corrupt" << endl;
		return 1;
	}

	fseek (iniFile, 0L, SEEK_END);

	unsigned uSize = ftell(iniFile);
	char *buffer = new char [uSize];
	char *szTemp = new char [80];

	rewind (iniFile);
	if (!buffer)
	{
		cout << "Buffer allocation FAILED...\n";
		exit (1);
	}
	else
		cout << "Buffer was allocated with: " << uSize << " bytes" << endl;
	register int i = 0;
	while (!feof(iniFile))
	{
		buffer[i] = getc ( iniFile );
		i++;
	}

	process_query ( buffer );

	fclose ( iniFile );
	delete [] buffer;
	delete [] szTemp;
        return 0;
}

main ()
{
	int ok = 0;
	char command [256];
	FILE *inifile;
#ifndef MSDOS
	init_curses();
#endif
	process_ini ();

	do
	{
		clrscr();
		cout << endl;
                cout << LightBlue << "1" << LightBlack << "]" << Normal << " Author Name       : " << Convert.AuthorName << endl;
                cout << LightBlue << "2" << LightBlack << "]" << Normal << " HTML Document Name: " << Convert.DocumentName << endl;
                cout << LightBlue << "3" << LightBlack << "]" << Normal << " C++ Output Name   : " << Convert.OutputName << endl;
                cout << LightBlue << "4" << LightBlack << "]" << Normal << " Routine Name      : " << Convert.RoutineName << endl;
                cout << LightBlue << "5" << LightBlack << "]" << Normal << " Method            : " << Convert.Method << endl;
                cout << LightBlue << "6" << LightBlack << "]" << Normal << " Program Name      : " << Convert.ProgramName << endl;
                cout << LightBlue << "7" << LightBlack << "]" << Normal << " CGI Data Directory: " << Convert.DataDirectory << endl;
                cout << LightBlue << "8" << LightBlack << "]" << Normal << " Compile" << endl;
                cout << LightBlue << "O" << LightBlack << "]" << Normal << " Options" << endl;
                cout << LightBlue << "X" << LightBlack << "]" << Normal << " End program" << endl;
                cout << endl << LightBlue << ":" << LightBlack << "] " << Normal;
		switch (hotk())
		{
                        case 'X':
                        case 'x':
                                exit (0);
                        case 'O':
                        case 'o':
                                set_options ();
                                break;
                        case '1':
				strcpy (Convert.AuthorName, GetCharInput (AUTHOR));
				break;
			case '2':
				strcpy (Convert.DocumentName, GetCharInput (DOCUMENT));
				break;
			case '3':
				strcpy (Convert.OutputName, GetCharInput (OUTPUT));
				break;
			case '4':
				strcpy (Convert.RoutineName, GetCharInput (ROUTINE));
				break;
			case '5':
				strcpy (Convert.Method, GetCharInput (METHOD));
				break;
			case '6':
				strcpy (Convert.ProgramName, GetCharInput (PROGRAMNAME));
				break;
			case '7':
				strcpy (Convert.DataDirectory, GetCharInput (DATADIRECTORY));
				break;
			case '8':
				cout << "Converting Document..." << endl;
				GetConvertInfo (Convert.DocumentName, Convert.OutputName, Convert.RoutineName);
				if (!(strcmp (Convert.Method, "GET")))
				{
					MakeMakefile (GET);
					MakeCGIget ();
				}
				else
				{
					MakeMakefile (POST);
				//	MakeCGIpost ();
				}
                                if (Options.Counter)
                                        MakeCounterCPP ();
                                if (Options.LogFile)
                                {
                                        MakeLogFileHeader ();
                                        MakeLogFileCPP ();
                                }
				MakeDefaults ();
				MakeTags ();
				cout << "Makeing the CGI-BIN" << endl;
				system ("make -f Makefile.mak");
				ok = 1;
			default:
				break;

		}
	} while (!ok);
	return 0;
}
