/*
 * 20/10/95	Updated the Dynamic Memory Allocation code
 * 
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <iomanip.h>
#include "convert.h"

#define TRUE	1
#define FALSE	0

#define elif	else if

#define PROGNAME	"html2cpp"
#define PROGAUTHOR		"lifestlr@straightup.znet.com"

FILE *infile, *outfile;

void PrepareModule (char *FunctionName)
{
	fprintf ( outfile, "#include <stdio.h>\n" );
	fprintf ( outfile, "#include \"tags.h\"\n" );
	fprintf ( outfile, "#include \"defaults.h\"\n" );
	fprintf ( outfile, "\n\n" );
	fprintf ( outfile, "// This file was created using Scott Griffith's %s.\n", PROGNAME );
	fprintf ( outfile, "// Please report any bugs to: %s\n", PROGAUTHOR );
	fprintf ( outfile, "//=========================================================\n" );
	fprintf ( outfile, "// USAGE:\n" );
	fprintf ( outfile, "// ======\n" );
	fprintf ( outfile, "//     To use this file, include the .h in your source and then\n" );
	fprintf ( outfile, "//  simply call it using the the name of the file you used as input\n");
	fprintf ( outfile, "//  minus the extension if any.\n\n" );
	fprintf	( outfile, "void %s ()\n", FunctionName );
	fprintf ( outfile, "{\n" );
}

void finish_module ()
{
	fprintf ( outfile, "\n}\n\n" );
	fprintf ( outfile, "// DO NOT WRITE BELOW THIS LINE\n" );
}

void convert ( char *buffer )
{

		fprintf ( outfile, "\nprintf ( \"" );

		while ( *buffer != '\n' )
		{
			if (*buffer == '\"')
			{
				fprintf ( outfile, "\\\"" );
				*buffer++;
			}
			fprintf ( outfile, "%c", *buffer );
			*buffer++;
		}
		fprintf ( outfile, "%%c\", LF );" );
}

void GetConvertInfo ( char *DocumentName, char *OutputName, char *RoutineName)
{
unsigned long uSize;
char *buffer;

	if (!DocumentName)
	{
		cout << "no input filename given\n";
		exit(1);
	}

	if (!OutputName)
	{
		
		cout << "no output filename given, using default\n";
		outfile = fopen ( "default.h", "w");
	}
	else
		outfile = fopen ( OutputName, "w" );

	infile = fopen ( DocumentName, "r");
	if (!infile)
	{
		cout << "File Does NOT Exist!" << endl;
		exit(1);
	}
	
	PrepareModule (RoutineName);
	while (!feof(infile))
	{
		buffer = (char *) malloc (255);
		if (!buffer)
		{
			cout << "Buffer allocation FAILED...\n";
			exit (1);
		}
		memset ( buffer, '\0', 255 );
		if (fgets ( buffer, 255, infile ))
			convert ( buffer );
		free (buffer);
        }
	finish_module ();

	fclose ( infile );
	fclose ( outfile );
}
