#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "prototypes.h"
#include "options.h"
#include "convert.h"
#include "config.h"

void MakeLogFileCPP ()
{
FILE *LogFileCPP;

        LogFileCPP = fopen ( "logfile.cpp", "w" );
        fprintf (LogFileCPP,"// Output created by HTML2CPP, written by Scott W. Griffith, 1995\n\n");
        fprintf (LogFileCPP,"#include <iostream.h>\n");
        fprintf (LogFileCPP,"#include <stdlib.h>\n");
        fprintf (LogFileCPP,"#include <stdio.h>\n");
        fprintf (LogFileCPP,"#include \"logfile.h\"\n");
        fprintf (LogFileCPP,"\n"); 
        fprintf (LogFileCPP,"extern char *LogPath;\n");
        fprintf (LogFileCPP,"\n");
        fprintf (LogFileCPP,"HTTPrec http;\n");
        fprintf (LogFileCPP,"\n");
        fprintf (LogFileCPP,"void GetLogInfo ()\n");
        fprintf (LogFileCPP,"{\n");
        fprintf (LogFileCPP,"        http.AuthType         = getenv (\"AUTH_TYPE\");\n");
        fprintf (LogFileCPP,"        http.ContentLength    = getenv (\"CONTENT_LENGTH\");\n");
        fprintf (LogFileCPP,"        http.ContentType      = getenv (\"CONTENT_TYPE\");\n");
        fprintf (LogFileCPP,"        http.GatewayInterface = getenv (\"GATEWAY_INTERFACE\");\n");
        fprintf (LogFileCPP,"        http.PathInfo         = getenv (\"PATH_INFO\");\n");
        fprintf (LogFileCPP,"        http.PathTranslated   = getenv (\"PATH_TRANSLATED\");\n");
        fprintf (LogFileCPP,"        http.QueryString      = getenv (\"QUERY_STRING\");\n");
        fprintf (LogFileCPP,"        http.RemoteAddress    = getenv (\"REMOTE_ADDR\");\n");
        fprintf (LogFileCPP,"        http.RemoteHost       = getenv (\"REMOTE_HOST\");\n");
        fprintf (LogFileCPP,"        http.RemoteID         = getenv (\"REMOTE_IDENT\");\n");
        fprintf (LogFileCPP,"        http.RemoteUser       = getenv (\"REMOTE_USER\");\n");
        fprintf (LogFileCPP,"        http.RequestMethod    = getenv (\"REQUEST_METHOD\");\n");
        fprintf (LogFileCPP,"        http.ScriptName       = getenv (\"SCRIPT_NAME\");\n");
        fprintf (LogFileCPP,"        http.ServerName       = getenv (\"SERVER_NAME\");\n");
        fprintf (LogFileCPP,"        http.ServerPort       = getenv (\"SERVER_PORT\");\n");
        fprintf (LogFileCPP,"        http.ServerProtocol   = getenv (\"SERVER_PROTOCOL\");\n");
        fprintf (LogFileCPP,"        http.ServerSoftware   = getenv (\"SERVER_SOFTWARE\");\n");
        fprintf (LogFileCPP,"}\n");
        fprintf (LogFileCPP,"\n");
        fprintf (LogFileCPP,"void WriteLog ()\n");
        fprintf (LogFileCPP,"{\n");
        fprintf (LogFileCPP,"FILE *Logfile;\n");
        fprintf (LogFileCPP,"\n");
        fprintf (LogFileCPP,"        Logfile = fopen ( LogPath, \"wb\" );\n");
        fprintf (LogFileCPP,"        fwrite ( &http, sizeof (http), 1, Logfile );\n");
        fprintf (LogFileCPP,"}\n");
        fprintf (LogFileCPP,"\n");
        fprintf (LogFileCPP,"int ReadLog ()\n");
        fprintf (LogFileCPP,"{\n");
        fprintf (LogFileCPP,"FILE *Logfile;\n");
        fprintf (LogFileCPP,"\n");
        fprintf (LogFileCPP,"        if (!(Logfile = fopen ( LogPath, \"rb\" )))\n");
        fprintf (LogFileCPP,"        {\n");
        fprintf (LogFileCPP,"                cout << \"Either file is corrupt or it doesn't exist\";\n");
        fprintf (LogFileCPP,"                return 1;\n");
        fprintf (LogFileCPP,"        }\n");
        fprintf (LogFileCPP,"        fread ( &http, sizeof (http), 1, Logfile );\n");
        fprintf (LogFileCPP,"        return 0;\n");
        fprintf (LogFileCPP,"}\n");
        fclose (LogFileCPP);
}


void MakeLogFileHeader ()
{
FILE *LogfileH;
        LogfileH = fopen ( "logfile.h", "w");
        fprintf (LogfileH, "// Output created by HTML2CPP, written by Scott W. Griffith, 1995\n\n");
        fprintf (LogfileH, "char *LogPath = \"%s\";\n\n", LogFile.Path);
        fprintf (LogfileH, "typedef struct\n");
        fprintf (LogfileH, "{\n");
        fprintf (LogfileH, "        char *AuthType,\n");
        fprintf (LogfileH, "             *ContentLength,\n");
        fprintf (LogfileH, "             *ContentType,\n");
        fprintf (LogfileH, "             *GatewayInterface,\n");
        fprintf (LogfileH, "             *PathInfo,\n");
        fprintf (LogfileH, "             *PathTranslated,\n");
        fprintf (LogfileH, "             *QueryString,\n");
        fprintf (LogfileH, "             *RemoteAddress,\n");
        fprintf (LogfileH, "             *RemoteHost,\n");
        fprintf (LogfileH, "             *RemoteID,\n");
        fprintf (LogfileH, "             *RemoteUser,\n");
        fprintf (LogfileH, "             *RequestMethod,\n");
        fprintf (LogfileH, "             *ScriptName,\n");
        fprintf (LogfileH, "             *ServerName,\n");
        fprintf (LogfileH, "             *ServerPort,\n");
        fprintf (LogfileH, "             *ServerProtocol,\n");
        fprintf (LogfileH, "             *ServerSoftware;\n");
        fprintf (LogfileH, "} HTTPrec;\n\n");
        fprintf (LogfileH, "extern HTTPrec http;\n");
        fclose (LogfileH);
}

void MakeCounterCPP ()
{

FILE *CounterCPP;

        CounterCPP = fopen ("counter.cpp", "w");
        
        fprintf (CounterCPP,"// Output created by HTML2CPP, written by Scott W. Griffith, 1995\n\n");
        fprintf (CounterCPP, "#include <stdio.h>\n");
        fprintf (CounterCPP, "\n");
        fprintf (CounterCPP, "extern char *datapath;\n");
        fprintf (CounterCPP, "\n");
        fprintf (CounterCPP, "FILE *datafile;\n");
        fprintf (CounterCPP, "\n");
        fprintf (CounterCPP, "typedef struct\n");
        fprintf (CounterCPP, "{\n");
        fprintf (CounterCPP, "unsigned int     accessed,\n");
        fprintf (CounterCPP, "                 last_accessed;\n");
        fprintf (CounterCPP, "} times;\n");
        fprintf (CounterCPP, "\n");
        fprintf (CounterCPP, "void increment ()\n");
        fprintf (CounterCPP, "{\n");
        fprintf (CounterCPP, "\n");
        fprintf (CounterCPP, "unsigned long accessed = 0;\n");
        fprintf (CounterCPP, "\n");
        fprintf (CounterCPP, "        if (!(datafile = fopen ( datapath , \"rb\" )))\n");
        fprintf (CounterCPP, "        {\n");
        fprintf (CounterCPP, "                datafile = fopen ( datapath, \"wb\" );\n");
        fprintf (CounterCPP, "                accessed = 0;\n");
        fprintf (CounterCPP, "                fwrite ( &accessed, sizeof (accessed), 1, datafile );\n");
        fprintf (CounterCPP, "                printf (\"File was created\\n\");\n");
        fprintf (CounterCPP, "                fclose (datafile);\n");
        fprintf (CounterCPP, "        }\n");
        fprintf (CounterCPP, "        fread ( &accessed, sizeof (accessed), 1, datafile );\n");
        fprintf (CounterCPP, "        fclose (datafile);\n");
        fprintf (CounterCPP, "        accessed += 1;\n");
        fprintf (CounterCPP, "        printf ( \"this page has been accessed %%ld\\n\", accessed );\n");
        fprintf (CounterCPP, "        datafile = fopen ( datapath, \"wb\" );\n");
        fprintf (CounterCPP, "        fwrite ( &accessed, sizeof (accessed), 1, datafile );\n");
        fprintf (CounterCPP, "        fclose (datafile);\n");
        fprintf (CounterCPP, "}\n");
        fclose (CounterCPP);
}

void MakeMakefile (int type)
{
FILE *makefile;
char *makeDOSstring;
char *makeUNIXstring;

	
        if (Options.GenerateFiles)
        {
                makefile = fopen ("Makefile.mak", "w");
                fprintf (makefile, "## Output created by HTML2CPP, written by Scott W. Griffith, 1995\n\n");
                if (Options.OperatingSystem)
                {
                        makeUNIXstring = new char [255];
                        sprintf (makeUNIXstring, "all:\n	g++ -O2 -o %s %s", Convert.ProgramName, Convert.OutputName);

                        if (type == GET)
                        {
                                if (Options.Counter)
                                        strcat (makeUNIXstring, " counter.cpp");
                                if (Options.LogFile)
                                        strcat (makeUNIXstring, " logfile.cpp");
                                strcat (makeUNIXstring, " cgiget.cpp");
                        }
                        if (type == POST)
                        {
                                if (Options.Counter)
                                        strcat (makeUNIXstring, " counter.cpp");
                                if (Options.LogFile)
                                        strcat (makeUNIXstring, " logfile.cpp");
                                strcat (makeUNIXstring, " cgipost.cpp");
                        }
                        fprintf ( makefile, makeUNIXstring );
                        delete [] makeUNIXstring;
                }
                else
                {
                        makeDOSstring = new char [255];
                        sprintf (makeDOSstring, "all:\n	bcc -O2 %s", Convert.ProgramName);

                        if (type == GET)
                        {
                                if (Options.Counter)
                                        strcat (makeDOSstring, " counter.cpp");
                                if (Options.LogFile)
                                        strcat (makeDOSstring, " logfile.cpp");
                                strcat (makeDOSstring, " cgiget.cpp");
                        }
                        if (type == POST)
                        {
                                if (Options.Counter)
                                        strcat (makeDOSstring, " counter.cpp");
                                if (Options.LogFile)
                                        strcat (makeDOSstring, " logfile.cpp");
                                strcat (makeDOSstring, " cgipost.cpp");
                        }
                        fprintf ( makefile, makeDOSstring );
                        delete [] makeDOSstring;
                }
                fclose (makefile);
        }
}

void WritePrototypeHeader ()
{
FILE *protos;

        if (Options.GenerateFiles)
        {
                protos = fopen ( "protos.h", "w" );
                fprintf ( protos, "// Output created by HTML2CPP, written by Scott W. Griffith, 1995\n\n" );
                fprintf ( protos, "#define LF   char(10)\n\n" );
                fprintf ( protos, "void increment ();\n" );
                fprintf ( protos, "void %s ();\n", Convert.RoutineName );
                fclose (protos);
        }
}

void MakeCGIget()
{
FILE *CGIget;

        if (Options.GenerateFiles)
        {
                WritePrototypeHeader ();
                CGIget = fopen ( "cgiget.cpp", "w" );
                fprintf (CGIget, "// Output created by HTML2CPP, written by Scott W. Griffith, 1995\n\n");
                fprintf (CGIget, "#include <iostream.h>\n");
                fprintf (CGIget, "#include \"protos.h\"\n\n");
                if (!Options.OperatingSystem)
                        fprintf (CGIget, "      char *datapath = \"%s\\%s.dat\";\n\n", Convert.DataDirectory, Convert.ProgramName);
                else
                        fprintf (CGIget, "      char *datapath = \"%s/.%s.dat\";\n\n", Convert.DataDirectory, Convert.ProgramName);
                fprintf (CGIget, "int main ()\n");
                fprintf (CGIget, "{\n");
                fprintf (CGIget, "      cout << \"Content-type:  text/html\" << LF << LF;\n");
                fprintf (CGIget, "      %s();\n", Convert.RoutineName);
                if (Options.Counter)
                        fprintf (CGIget, "      increment();\n");
                fprintf (CGIget, "      return 0;\n");
                fprintf (CGIget, "}\n");
                fclose (CGIget);
         }
}

void MakeTags ()
{
FILE *Tags;

        if (Options.GenerateFiles)
        {
                Tags = fopen ("tags.h", "w");
                fprintf (Tags, "// Output created by HTML2CPP, written by Scott W. Griffith, 1995\n\n");
                fprintf (Tags, "#define HTML_   cout << \"<HTML>\" << LF;");
                fclose (Tags);
        }
}

void MakeDefaults ()
{
FILE *Defaults;

        if (Options.GenerateFiles)
        {
                Defaults = fopen ( "defaults.h", "w" );
                fprintf ( Defaults, "// Output created by HTML2CPP, written by Scott W. Griffith, 1995\n\n" );
                fprintf ( Defaults, "#define AUTHOR     \"%s\"\n", Convert.AuthorName );
                fprintf ( Defaults, "#define LF         char(10)\n" );
                fclose ( Defaults );
        }
}
