/**************************************************************************
*
* FunktrackerGOLD - By Jason Nunn
* (Derived from the DOS32 FunkTracker module - FUNKLITE.ASM)
*
* The Playback types..
*
* Snail: 32 Rothdale Road, Moil, Darwin, NT, 0810, Australia
*
* ======================================================================
*
* NB/ Funktracker was first developed with Borland Turbo Assembler
* in 80386 Intel 32 bit Assembly for Protected mode, and i have converted
* it to ANSI C for Unix purposes.
*
**************************************************************************/

/*******************************************
* alignment essential structures
*******************************************/
typedef struct _tfunk_sb
{
  sDB sname[19];
  uDD start;
  uDD length;
  uDB volume;
  uDB balance;
  uDB pt_and_sop;
  uDB vv_waveform;
  uDB rl_and_as;
} tfunk_sb;

typedef struct _tfunk_hr
{
  sDB      sig[4];
  uDB      info[4];
  uDD      LZH_check_size;
  sDB      funk_type[4];
  uDB      loop_order;
  uDB      order_list[256];
  uDB      break_list[128];
  tfunk_sb funk_sb[64];
} tfunk_hr;

typedef struct _tslot
{
  uDB not_sam;
  uDB sam_com;
  uDB com_val;
} tslot;

/*******************************************
* alignment not essential
*******************************************/
typedef struct _tfunk_chan
{
/*-control system-----------------*/
  int channel_kill;
  int command;
  int com_val;
  int comspd_count;
  int sample;
  int port_type;
  int sample_ofs_parm;
  int vib_waveform;
  int vol_vib_waveform;
  int retrig_spd_count;
  int retrig_count;
  int retrig_limit;
  int arp_speed;
  int balance;
  tslot *delay_pattern_ptr;
/*-note system--------------------*/
  unsigned char note_command;
  unsigned char note_com_val;
  int note_comspd_count;
  int note;
  long ifreq;
  long ifreq_vibrato;
  long ifreq_portdest;
  long rfreq;
  long rfreq_portdest;
  int vib_ptr;
  int note_beat_count;
/*-volume system-----------------*/
  unsigned char volume_command;
  unsigned char volume_com_val;
  int volume_comspd_count;
  int volume;                  /*changed from uchar to DD*/
  int volume_vibrato;
  int volume_portdest;
  int rvolume;
  int vol_vib_ptr;
  int volume_beat_count;
} tfunk_chan;

typedef struct _tfunk_info
{
  int           trek_status;
  int           sequence_ofs;
  int           pattern_ofs_display;
  int           sequence_ofs_display;
  int           pattern_ofs;
  int           tempo;
  int           tempo_count;
  int           no_of_patterns;
  int           no_of_sequences;
  int           master_volume;
  unsigned long sample_block_size;
  int           funk_pd_size;
} tfunk_info;

