
#include "cblogin.h"

void first_login(char *username)
{
    int
	dest,
	uid;

    log(log_on, "starting first_login()");

    uid = validate(username);	/* validate the user name  or exit (1) */

    listdestinations(uid, 0);	/* show list of allowed names (0: not 'all') */

    dest = get_destination(uid);	/* determine destination */

    switch (get_destmode(dest))
    {
	case direct_mode:           /* direct requested ? */
	    log(log_on, "Direct login for %s", username);
	    exec_login(uid);	    /* then run the login program */

	case extra_mode:
	    ask_extra_number(uid, dest); /* ask for extra destination */
	break;

	default:			/* to catch the phonemode */
    }

    setcallback(uid, dest);              /* set callback mode */

    printf
    (
	"\n"
	"Please break the connection.\n"
	"Stand by to accept the next incoming call as a callback.\n"
    );
}
