
#include "process.p"

int modemkill(char *processline)
{                                    
    int 
        kills,
        pid;
    char
        *cp,
        *modem,
        *line;
               
    modem = getmodembase();

    if ((cp = strrchr(modem, '/')))             /* look for the last part of */
        modem = cp + 1;                         /* the modembase: beyond /   */

    log(log_max, "process: '%s'", processline);
    if (!strstr(processline, modem))
    {
        log(log_max, "no modem process on this line");
        return (0);                             /* no modem process */
    }
              
    kills = 0;
    reset_active_tty();
    while ((line = get_active_tty()))           /* check actives */
    {
        if (strstr(processline, line))          /* modembase and line found */
        {
	    if (sscanf(processline, " %d", &pid) != 1)
	    	log(log_off, "Can't find PID in ps-output '%s'", processline);

	    else if (kill(pid, SIGTERM))
	    	log(log_off, "Can't 'kill(%d, SIGTERM)' for process '%s'", 
		     pid, processline);
            
            else
            {
                assign_filenames(line);
    	        log(log_on, "SIGTERM received by %s", getfile(the_modemfile));
                kills++;
            }
	}
        else
            log(log_max, "no modem process for line '%s'", line);
    }

    if (kills)
        return (kills);

    log(log_on, "Skipped modem-process: '%s'", processline);
    return (0);
}
    
