#ifndef _Biflex_H_
#define _Biflex_H_

/*
    In this file the variables and functions are declared which are 
    available when bison and flex are used to generate a parser 
    and a scanner.               

    It is assumed that a directory ./biflex exists where the grammar
    and the parser are maintained
    
    yylineno is defined in the lexer mold-file.

    Define YYSTYPE if needed here. E.g.,
    
        struct parsertack
        { 
            .. fields of the bison-parserstack
        };
    
        #define YYSTYPE parserstack

    Include 
*/

#ifndef _PARSER_TAB_H_
#define _PARSER_TAB_H_    
#include "biflex/parser.tab.h"  /* header generated by bison */
#endif                          /* defines YYSTYPE, unless defined here */

#define yywrap()    1


extern FILE
    *yyin,                  /* input and output streams used by yylex() */
    *yyout;                 /* flex-generated */

extern int
    yylineno,               /* line counter variable, defined in 'lexer' */
    yyleng;                 /* length of matched input, flex-generated */
                                                                     
extern YYSTYPE              /* semantical value used by the parser as $0 */
    yylval;                 /* bison-generated */

extern char                 /* information matched by the lexer */
    *yytext;                /* flex generated */

int yylex(void);            /* the lexical scanner, flex-generated */
int yyparse(void);          /* the parser, bison-generated */

int yyerror(char *msg);     /* generic parser error function */
                            /* (should be char const *msg, but the given */
                            /* prototype is expected by yyparse() */

#endif  _Biflex_H_
