
#include "dest.p"

void listdestinations(int uid, int all)
{
    int
	dindex,
	gindex;
    DESTINATION_
	*dp;
    unsigned 
	groupidx;
						/* walk the groups */

                                                /* all listings suppressed */
    if (!givedestinations() && !givedirect() && !giveextra())
        return;

    printf("\n"
	    "Callback destinations for %s:\n"
	    "----------------------------------\n", username(uid));

    for (gindex = 0; gindex < user_ngroups(uid); gindex++)
    {						
	groupidx = usergroup(uid, gindex);      /* point to the group */

						/* walk the destinations */
	for (dindex = 0; dindex < ndestinations; dindex++)
	{
	    dp = &destination[dindex];		/* use local pointer */

            switch (dp->mode)                   /* decide what to display */
            {
                case extra_mode:                /* extra not wanted */
                    if (!giveextra())
                        continue;
                break;

                case direct_mode:               /* direct not wanted */
                    if (!givedirect())
                        continue;
                break;

                case phone_mode:                /* destinations not wanted */
                    if (!givedestinations())
                        continue;
                break;
            }

	    if (groupidx == dp->dgroup)		/* group found */
	    {
		printf("%15s ", get_dname(dp->dname)); /* show dest. name */
			
		if (all)
		{
		    printf("-- %s\n", dp->phonenr);
		    if (dp->filename)
			printf("%15c    using %s\n", ' ', dp->filename);
		}
		else
		    printf("\n");
	    }
	}
    }
}
