
#include "dbase.p"

/*
    Make a new config file, before killing an mgetty process
*/
void make_configfile()
{
    FILE      
        *inf,
        *outf;
    char
        *line,
        *mgp,
	*buffer;
    int
        index;
             
    mgp = getmgettypath();

    outf = xfopen(mgp, "w");        /* open the final file */

    for (index = 0; (line = get_ttyline(index)); index++)
    {
	buffer = linename("active", line);  /* make the active-filename */
	if (!access(buffer, R_OK))	    /* file exists ? */
        {
            log(log_max, "Appending %s to %s", buffer, mgp);

            inf = xfopen(buffer, "r");      /* open to read */
            cpfile(inf, outf);              /* concatenate */
            fclose(inf);
        }
	free(buffer);			    /* free memory */
    }                                   

    fclose(outf);                           /* close the destination file */
    log(log_on, "New '%s' written", mgp);
}
