#ifndef _config_H_
#define _config_H_

#include "../mem/mem.h"
#include "../log/log.h"

typedef enum
{
    mode_callback,
    mode_dialin,
} CB_MODE_;
     
char *getbase();                    /* get the base-path */
char *getmodembase();               /* get the modembase */
char *getmgettypath();              /* get the mgetty-path */
CB_MODE_ getmode(void);              /* get the callback-mode */
int getcall();                      /* get the 'call' value */
char *getlogin();                   /* get the name of the login program */
char *get_emailaddress();           /* get the email address */
unsigned get_ntries();              /* get the number of tries */

void setcall();                     /* use the call verb */
void setemailaddress(char *name);   /* set the email-address */
void setloginprogram(char *name);   /* set the login program */
void setmgettypath(char *path);     /* set the path to the mgetty.config file */
void setmodembase(char *base);      /* set the callback-modembase */
void setmode(CB_MODE_ mode);        /* set the callback-mode */
void setntries(char *nr);           /* set the nr of retries */
void setbase(char *base);           /* set the base-path */
void checkconfig(void);             /* check the configuration */

int givephonenumbers();
int giveextra();
int givedirect();
int givedestinations();

void hidedestinations();
void showdestinations();
void showextra();
void showdirect();
void showphonenumbers();

#endif  _config_H_
