#ifndef _configure_H_
#define _configure_H_

/*
    Configuration options for callback: optionally change values
    mentioned here to your own choices, and run the
    
        build progs
    
    command
    
*/
    
/* In lib/config/configdata.c: 
   ~~~~~~~~~~~~~~~~~~~~~~~~~~~
*/

/* Max number of times callback tries to call back */
#define NTRIES              3       
     
/* What is the name of the modem-process (without the ttySx-suffix) */
#define MODEMPROCESS        "/sbin/modem"

/* What is the name of the receiver of mail ? (I don't like this, but */
/* guess it's available)                                              */
#define EMAIL_ADDRESS       "root"

/* What is the name of the login-program */
#define LOGIN_PROGRAM       "/bin/login" 

/* What is the name of the mgetty-config file for callback ? */
#define MGETTY_PATH         "/usr/local/etc/mgetty+sendfax/mgetty.config"

/* What is the name of the base-path for the callback-configuration files ? */
/* Note: the default MUST have a trailing /                                 */
#define BASE_PATH           "/conf/callback/"
    
/* In: lib/dbase/dbasedata.c: 
   ~~~~~~~~~~~~~~~~~~~~~~~~~~
*/

/* How many seconds may a callback-file exist ? */
#define MAXAGE              300
                                 
/* lib/log/logdata.c */

/* What is the name of the standard logfile ? */
#define LOGFILENAME         "/var/log/callback.log"

/* What is the name of the diallog-file ? */
#define DIALLOGFILENAME     "/dev/null"

/* What is the name of the panic logfile ? */
#define PANICLOGFILE        "/dev/console"

/**************************************************************************/  
/*  The following defines are not configurable via the configurationfiles */
/*  and must be given sensible values here                                */
/**************************************************************************/  

/* In lib/parser/parsesetupfile.c:
   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*/

/* Where are the callback-setup files found ? */
#define FIRSTSETUP	   "/etc/callback.setup"
#define SECONDSETUP	   "/usr/etc/callback.setup"
#define THIRDSETUP	   "/usr/local/etc/callback.setup"

/* In lib/process/killinit.c:
   ~~~~~~~~~~~~~~~~~~~~~~~~~~
*/

/* Process-id of init. Should be 1. */
#define PID_INIT		1

/* In lib/process/modemrespawn.c:
   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*/

/*  Program to determine the running processes. */
#define PSCMD			"ps -ax"

/*  In policy.h: 
    ~~~~~~~~~~~~ 
  
    policy.h is the policy.h file used for compiling mgetty. The only
    entry of this file that's used by callback is the NOLOGIN_FILE entry
    either include your policy.h, or define NOLOGIN_FILE here, but make
    sure the define used here matches the define in policy.h

    If that file exists, a ringing phone won't be answered (see manual).
    "%s" will be replaced by the device name.
*/    
#define NOLOGIN_FILE    "/etc/nologin.%s"


#endif _configure_H_
