/* editline.c  prototypes */
#ifdef CLINT
#include "editline.h"
SIZE_T FindMatches( char *path, char ***avp ) ;
#endif
/*
**  Command status codes.
*/
#define CASE enum TOULR
CASE { TOupper, TOlower } ;
#define STATUS enum RSTAT
STATUS { CSdone, CSeof, CSmove, CSdispatch, CSstay } ;

 char *readline( char *prompt, int scrollflag);
 void add_history(char *p);
 void columns(int ac, CHAR **av);
 void TTYflush(void);
 STATIC void TTYput( CHAR c);
 STATIC void TTYputs( CHAR *p);
 STATIC void TTYshow( CHAR c);
 STATIC void TTYstring( CHAR *p);
 STATIC UNSI TTYget(void);
 STATIC void TTYbackn(int n);
 STATIC void TTYinfo(void);
 STATIC void reposition(void);
 STATIC void left(STATUS Change);
 STATIC void right(STATUS Change);
 STATIC STATUS ring_bell(void);
 STATIC STATUS do_macro(unsigned int c);
 STATIC STATUS do_forward(STATUS move);
 STATIC STATUS do_case(CASE type);
 STATIC STATUS case_down_word(void);
 STATIC STATUS case_up_word(void);
 STATIC void ceol(void);
 STATIC void clear_line(void);
 STATIC STATUS insert_string(CHAR *p);
 STATIC CHAR *next_hist(void);
 STATIC CHAR *prev_hist(void);
 STATIC STATUS do_insert_hist(CHAR *p);
 STATIC STATUS do_hist(CHAR *(*move)());
 STATIC STATUS h_next(void);
 STATIC STATUS h_prev(void);
 STATIC STATUS h_first(void);
 STATIC STATUS h_last(void);
 STATIC int substrcmp(char *text, char *pat, int len);
 STATIC CHAR *search_hist(CHAR *search, CHAR *(*move)());
 STATIC STATUS h_search(void);
 STATIC STATUS fd_char(void);
 STATIC void save_yank(int begin, int i);
 STATIC STATUS delete_string(int count);
 STATIC STATUS bk_char(void);
 STATIC STATUS bk_del_char(void);
 STATIC STATUS redisplay(void);
 STATIC STATUS kill_line(void);
 STATIC STATUS insert_char(int c);
 STATIC STATUS meta(void);
 STATIC STATUS emacs(unsigned int c);
 STATIC STATUS TTYspecial(unsigned int c);
 STATIC CHAR *editinput(void);
 STATIC void hist_add(CHAR *p);
 void rl_reset_terminal(char *p);
 void rl_initialize(void);
 STATIC STATUS beg_line(void);
 STATIC STATUS del_char(void);
 STATIC STATUS end_line(void);
 STATIC CHAR *find_word(void);
 STATIC STATUS c_complete(void);
 STATIC STATUS c_possible(void);
 STATIC STATUS accept_line(void);
 STATIC STATUS transpose(void);
 STATIC STATUS quote(void);
 STATIC STATUS wipe(void);
 STATIC STATUS mk_set(void);
 STATIC STATUS exchange(void);
 STATIC STATUS yank(void);
 STATIC STATUS copy_region(void);
 STATIC STATUS move_to_char(void);
 STATIC STATUS fd_word(void);
 STATIC STATUS fd_kill_word(void);
 STATIC STATUS bk_word(void);
 STATIC STATUS bk_kill_word(void);
 STATIC int argify(CHAR *line, CHAR ***avp);
 STATIC STATUS last_argument(void);
extern char *luxptr ;
