/*
 * Copyright (C) 1993 DataSoft Communications
 *
 * This software is distrubuted under the GNU Public Licence. As such
 * distribution of the software must contain the source code with this
 * copywrite notice intacted.
 *
 * DataSoft Communications supplies this software on an "as is" basis
 * and without warranty of any kind.
 *
 * Mark Buckaway
 * DataSoft Communications
 * mark@datasoft.north.net
 */

#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/file.h>
#include <sys/types.h>
#include <fcntl.h>
#include <mntent.h>
#include <string.h>
#include <errno.h>
#include <linux/cdrom.h>


#define NUMKW 5

#define PLAY 0
#define STOP 1
#define INFO 2
#define PAUSE 3

static char *keywords[NUMKW]={"play","stop","info","pause",NULL};
const char cdrom[]="/dev/mcd";

int main(int argc, char *argv[])
{
     int i,f;
     struct cdrom_tochdr tochdr;
     struct cdrom_tocentry tocentry;
     struct cdrom_ti ti;
     struct mntent *mnt;
     FILE *fp;

     fputs("CDplayer V0.1 by Mark Buckaway\n(C) 1993 DataSoft Communications\n",stderr);
     if (argc<2) {
	  fputs("Usage: cdplayer command {track no}\n",stderr);
	  fputs("Available commands: ",stderr);
	  for (i=0;i<(NUMKW-1);i++) {
	       fprintf(stderr,"%s ",keywords[i]);
	  }
	  fputs("\nNOTE: play command can take a track number\n",stderr);
	  exit(1);
     }
     /* Check if drive is mounted */
     if ((fp=setmntent(MOUNTED,"r"))==NULL) {
	  fprintf(stderr,"Couldn't open %s: %s\n",MOUNTED,strerror(errno));
	  exit(1);
     }
     while ((mnt=getmntent(fp))!=NULL) {
	  if (strcmp(mnt->mnt_type,"iso9660")==0) {
	       fputs("CDROM already mounted. Operation aborted.\n",stderr);
	       endmntent(fp);
	       exit(1);
	  }
     }
     endmntent(fp);
     /* Open the CDROM drive for read only */
     if ((f=open(cdrom,O_RDONLY))==-1) {
	  perror("error opening cdrom");
	  exit(1);
     }
     /* get table of content entries for min and max tracks */
     if ((ioctl(f,CDROMREADTOCHDR,&tochdr))==-1) {
	  perror("ioctl(CDROMREADTOHDR)");
	  exit(1);
     }
     /* scan argument list */
     for (i=0;i<NUMKW;i++) {
	  if ((strcmp(argv[1],keywords[i]))==0) break;
     }
     /* do requested operation */
     switch (i) {
	  case PLAY:
	       /* set to play first track to the last */
	       if (argc==3) {
		    i=atoi(argv[2]);
		    if ((i<tochdr.cdth_trk0) || (i>tochdr.cdth_trk1)) {
			 fprintf(stderr,"CDplayer: Invalid track %d - ignored\n",i);
			 ti.cdti_trk0=tochdr.cdth_trk0;
		       } else {
			 ti.cdti_trk0=i;
		    }
		  } else {
		    ti.cdti_trk0=tochdr.cdth_trk0;
	       }
	       ti.cdti_ind0=1;
	       ti.cdti_trk1=tochdr.cdth_trk1;
	       ti.cdti_ind1=1;
	       if ((ioctl(f,CDROMPLAYTRKIND,&ti))==-1) {
		    perror("ioctl(CDROMPLAYTRKIND)");
		    exit(1);
	       }
	       printf("CDplayer: playing CD from track %d\n",ti.cdti_trk0);
	       break;
	  case STOP:
	       if ((ioctl(f,CDROMPAUSE))==-1) {
		    perror("ioctl(CDROMPAUSE)");
		    exit(1);
	       }
	       if ((ioctl(f,CDROMSTOP))==-1) {
		    perror("ioctl(CDROMSTOP)");
		    exit(1);
	       }
	       puts("CDplayer: CD stopped.");
	       break;
	   case INFO:
	       printf("CD has tracks=%u\n",tochdr.cdth_trk1);
	       tocentry.cdte_track=CDROM_LEADOUT;
	       tocentry.cdte_format=CDROM_MSF;
	       if ((ioctl(f,CDROMREADTOCENTRY,&tocentry))==-1) {
		    perror("ioctl(CDROMREADTOCENTRY)");
		    exit(1);
	       }
	       printf("Total playing time=%u min %u sec\n",tocentry.cdte_addr.msf.minute,tocentry.cdte_addr.msf.second);
	       for (i=tochdr.cdth_trk0;i<=tochdr.cdth_trk1;i++) {
		    tocentry.cdte_track=i;
		    tocentry.cdte_format=CDROM_MSF;
		    if ((ioctl(f,CDROMREADTOCENTRY,&tocentry))==-1) {
			 perror("ioctl(CDROMREADTOCENTRY)");
			 exit(1);
		    }
		    printf("Track %2d @ %2u min %2u sec\n",i,tocentry.cdte_addr.msf.minute,tocentry.cdte_addr.msf.second);
	       }
	       break;
	    case PAUSE:
	       if ((ioctl(f,CDROMPAUSE))==-1) {
		    perror("ioctl(CDROMPAUSE)");
		    exit(1);
	       }
	       puts("CDplayer: CD paused. Please ENTER to continue play.");
	       getchar();
	       if ((ioctl(f,CDROMRESUME))==-1) {
		    perror("ioctl(CDROMPAUSE)");
		    exit(1);
	       }
	       break;
	  default:
	       fputs("CDplayer: invalid argument",stderr);
     }
     close(f);
     return(0);
}
