/************************************************************************
*
*  CDP.C : Audio CD-ROM player for Linux   
*  Written by saby@balu.sch.bme.hu
*  (c)1993 Szijarto Szabolcs                            
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
************************************************************************/

#include <stdio.h>
#include <fcntl.h>
#include <linux/types.h>
#include <linux/cdrom.h>

#define cmd_no 6

char *cmd_name[cmd_no]={ "stop", "eject", "pause", "resume", "play", "toc" };
int cmds[cmd_no]={ CDROMSTOP, CDROMEJECT , CDROMPAUSE, 
		CDROMRESUME, CDROMPLAYTRKIND, CDROMREADTOCHDR };

struct cdrom_ti ti;
struct cdrom_tochdr tochdr;
struct cdrom_tocentry tocentry;

int main(int ac, char **av)
{
	int fn, i, r;
	u_char uc;
		
	printf("%s : audio CD player by saby@balu.sch.bme.hu\n", av[0]);

	if (ac<2) {
		fprintf(stderr, "Usage: %s <command> [arg1] [arg2]  \nValid commands are: ", *av);
		for(i=0;i<cmd_no;i++) printf("%s ", cmd_name[i]);
		putchar('\n');
		return 1;
	}
		
	if ((fn=open("/dev/cdrom", O_RDONLY))==-1) {
		fprintf(stderr, "Cannot open /dev/cdrom!\n");
		return 2;
	}
	
	for(i=0; i<cmd_no; i++) {
		if (!strcmp((const char *)tolower(av[1]), cmd_name[i])) break;
	}
	if (i==cmd_no) {
		fprintf(stderr, "Unknown command: %s\n", av[1]);
		return 3;
	}

	switch (cmds[i]) {
	case CDROMPLAYTRKIND :
			{
			if ((r=ioctl(fn, CDROMREADTOCHDR, &tochdr))!=0) break;
			ti.cdti_trk0=(ac>2) ? (u_char)atoi(av[2]) : tochdr.cdth_trk0;
			ti.cdti_trk1=(ac>3) ? (u_char)atoi(av[3]) : tochdr.cdth_trk1;
			printf("Playing tracks %d-%d...\n", ti.cdti_trk0,
							ti.cdti_trk1);
			ti.cdti_ind0=0;	/* What is this??? */
			ti.cdti_ind1=0;
			r=ioctl(fn, cmds[i], &ti);
			break;
			}
	case CDROMREADTOCHDR :
			{
			if ((r=ioctl(fn, CDROMREADTOCHDR, &tochdr))!=0) break;
			printf("Checking table of contents...\n");
			printf("start track: %d\n", tochdr.cdth_trk0);
			printf("  end track: %d\n\n", tochdr.cdth_trk1);
			for(uc=tochdr.cdth_trk0; uc<=tochdr.cdth_trk1; uc++) {
				tocentry.cdte_track=uc;
				ioctl(fn, CDROMREADTOCENTRY, &tocentry);
				printf("track no.:\t%d\n", tocentry.cdte_track);
				printf("format:\t%d\n", tocentry.cdte_format);
				printf("adr:\t%d\n", tocentry.cdte_adr);
				printf("ctrl:\t%d\n", tocentry.cdte_ctrl);
				printf("msf:\t%d:%d:%d\n", tocentry.cdte_addr.msf.minute,
							tocentry.cdte_addr.msf.second,
							tocentry.cdte_addr.msf.frame);
				printf("lba:\t%d\n\n", tocentry.cdte_addr.lba);
				};
			}
			break;
	default:	r=ioctl(fn, cmds[i]);
	}
	if (r!=0) printf("ioctl returned: %d\n", r);
	close(fn);
	
	return 0;
}
