/** 
 * 
 * xcci.c - (c) 1994 Copyright by John R. Punin
 *
 * ASHE
 *
 * This file has the routines to make connection with Mosaic using CCI and
 * with Netscape using remote functions
 *
 * John R. Punin      Sept - 25 - 1995
 *
*/
#include "xhtml.h"
#include "xcci.h"
#include "xheader.h"
#include "xform.h"


MCCIPort   ss_cci_port;
static long int   ss_port_num=0;
static char ss_host_name[STR_LEN];


void 
CCI_HTML(Widget w,HTMLED *he,XtPointer call_data)
{

  static Widget dialog=NULL,text_url=NULL;
  Widget text_port,name_box,label_host,text_host,title_cci,label_url;
  int name_len = STR_LEN;

  if(!dialog)
  {
     XmString cci_label = XmStringCreateLtoR("CCI Connection\n",
					     XmSTRING_DEFAULT_CHARSET);
     XmString url_label = XmStringCreateLtoR("URL to send :",
					     XmSTRING_DEFAULT_CHARSET);
     XmString host = XmStringCreateLtoR("Host Machine : ",
					XmSTRING_DEFAULT_CHARSET);
     XmString rt = XmStringCreateLtoR("Port Number (1025-65536) : ",
				      XmSTRING_DEFAULT_CHARSET); 
     
     XmString clear =XmStringCreateSimple("Clear");

     dialog = XmCreatePromptDialog(he->textarea,"CCIdialog",NULL,0);


     XtVaSetValues(dialog, 
		   XmNselectionLabelString,rt,
		   XmNapplyLabelString,clear,NULL);
     XmStringFree(rt);

     name_box = XmCreateForm(dialog,"namebox",NULL,0);
     
     label_url = XmCreateLabel(name_box,"label_url",NULL,0);
     XtVaSetValues(label_url,XmNlabelString,url_label,NULL);
     XmStringFree(url_label);

     text_url = XmCreateText(name_box,"text_url",NULL,0);
     
     label_host = XmCreateLabel(name_box,"label_host",NULL,0);
     XtVaSetValues(label_host,XmNlabelString,host,NULL);
     XmStringFree(host);

     text_host = XmCreateText(name_box,"text_host",NULL,0);
     
     title_cci = XmCreateLabel(name_box,"title_cci",NULL,0);
     XtVaSetValues(title_cci,XmNlabelString,cci_label,NULL);
     XmStringFree(cci_label);
     

     if(gethostname(ss_host_name,name_len)==0)
	XtVaSetValues(text_host, XmNvalue,ss_host_name,NULL);


     XtVaSetValues(text_url, XmNtopAttachment, XmATTACH_WIDGET, 
		   XmNtopWidget,label_url,
		   XmNleftAttachment, XmATTACH_FORM, 
		   XmNcolumns,27,
		   NULL);
     
     XtVaSetValues(label_url, XmNtopAttachment, XmATTACH_WIDGET, 
		   XmNtopWidget,title_cci,
		   XmNleftAttachment, XmATTACH_FORM,
		   NULL); 
     XtVaSetValues(text_host, XmNtopAttachment, XmATTACH_WIDGET, 
		   XmNtopWidget,label_host,
		   XmNleftAttachment, XmATTACH_FORM, 
		   XmNcolumns,27,
		   NULL);
     
     XtVaSetValues(label_host, XmNtopAttachment, XmATTACH_WIDGET, 
		   XmNtopWidget,text_url,
		   XmNleftAttachment, XmATTACH_FORM,
		   NULL); 
     XtVaSetValues(title_cci, XmNtopAttachment, XmATTACH_FORM, 
		   XmNleftAttachment, XmATTACH_FORM,
		   NULL);

     XtManageChild(text_url);
     XtManageChild(label_url); 
     XtManageChild(text_host);
     XtManageChild(label_host); 
     
     XtManageChild(title_cci);

     XtManageChild(name_box);

     XmStringFree(clear);
  
  /* When the user types the Port Number, call port_name()... */
  XtAddCallback(dialog,XmNokCallback,(XtCallbackProc)port_name,(XtPointer)he);   
   /* If the user selects cancel, just pop down the dialog */
     XtAddCallback(dialog,XmNcancelCallback,(XtCallbackProc)XtUnmanageChild,NULL); 
  /* Clear button is available */
     XtAddCallback(dialog,XmNapplyCallback,(XtCallbackProc)clear_title,NULL);
     XtManageChild(XmSelectionBoxGetChild(dialog, XmDIALOG_APPLY_BUTTON));

  /* No help is available */
     XtUnmanageChild(XmSelectionBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));

     text_port = XmSelectionBoxGetChild(dialog,XmDIALOG_TEXT);
     XtAddCallback(text_port,XmNmodifyVerifyCallback,
		   (XtCallbackProc)check_number, (XtPointer)5);
  }

  if(strcmp(he->Name_File,"*scratch*"))
  {
     char *url_file=malloc(STR_LEN);
     char *ptr = he->Name_File;

     if (ptr[0]!='/')
     {
	getwd(url_file);
	strcat(url_file,"/");
	strcat(url_file,ptr);
     }
     else
	strcpy(url_file,ptr);
  
     XmTextSetString(text_url,url_file);
     free(url_file);
  }     

  XtManageChild(dialog);
/*  XWarpPointer(XtDisplay(he->textarea),XtWindow(he->textarea),
		XtWindow(XmSelectionBoxGetChild(dialog,XmDIALOG_TEXT)),
                   0,0,800,800,0,0);*/
}
void port_name(Widget w,
		    XtPointer client_data,
		    XmSelectionBoxCallbackStruct *cbs)
{

   Widget dialog = XtNameToWidget(XtParent(w),"CCIdialog");
   Widget name_box = (dialog ? XtNameToWidget(dialog,"namebox"): NULL);
  Widget  text_host = (name_box ? XtNameToWidget(name_box,"text_host") : NULL);
    Widget  text_url = (name_box ? XtNameToWidget(name_box,"text_url") : NULL);
   char *host_name=(text_host ? XmTextGetString(text_host) : NULL);
   char *url_name =(text_url ? XmTextGetString(text_url) : NULL);

   char *value;

   if(host_name)
      strcpy(ss_host_name,host_name);
   
   if(cbs->value!=NULL)
   {
      XmStringGetLtoR(cbs->value,XmSTRING_DEFAULT_CHARSET,&value);

      ss_port_num = atoi(value);

      if(url_name)
	 ss_show_next_url(url_name);
   }

   if(host_name) XtFree(host_name);
   if(url_name) XtFree(url_name);
}

int ss_show_next_url(char *url) /* return 0 on success, or 1 on failure */
{

   if (!MCCIIsConnected(ss_cci_port))
      ss_make_cci_connection();

   if (MCCIIsConnected(ss_cci_port))
   {
      MCCIGet(ss_cci_port, url, MCCI_DEFAULT, MCCI_ABSOLUTE, 0);
      return 0;
   }
   else
      return 1;
}

int ss_make_cci_connection(void)  /* return 0 on success, 1 or 2 on failure */
{
  ss_cci_port=(MCCIPort) MCCIConnect(ss_host_name, ss_port_num, NULL, NULL);
  if (!ss_cci_port)
  {
      printf("\n Error, could not connect to machine %s at port %ld.\n",
	     ss_host_name, ss_port_num);
      return 0;
   }
  return 1;
}

void NET_HTML(Widget w,HTMLED *he,XtPointer call_data)
{
   static Widget dialog;

   if(!dialog)
   {
      XmString net_label = XmStringCreateLtoR("Netscape Connection\n",
					      XmSTRING_DEFAULT_CHARSET);
      
      XmString Load =XmStringCreateSimple("Load");
      XmString Reload =XmStringCreateSimple("Reload");
      
      dialog = XmCreatePromptDialog(he->textarea,"NETdialog",NULL,0);

      XtVaSetValues(dialog, 
		    XmNselectionLabelString,net_label,
		    XmNokLabelString,Load,
		    XmNapplyLabelString,Reload,NULL);


      XmStringFree(Load);      XmStringFree(Reload);
      XmStringFree(net_label);


      /* If the user selects cancel, just pop down the dialog */
      XtAddCallback(dialog,XmNcancelCallback,(XtCallbackProc)XtUnmanageChild,
		    NULL);
      /* When the user Load a file, call load_net()... */
      XtAddCallback(dialog,XmNokCallback,(XtCallbackProc)load_net,
		    (XtPointer)he);

      /* Reload button is available */
      XtAddCallback(dialog,XmNapplyCallback,(XtCallbackProc)reload_net,NULL);
      XtManageChild(XmSelectionBoxGetChild(dialog, XmDIALOG_APPLY_BUTTON));

      /* Neither help nor text is available */
      XtUnmanageChild(XmSelectionBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));
      XtUnmanageChild(XmSelectionBoxGetChild(dialog, XmDIALOG_TEXT));
   }
   XtVaSetValues(dialog,XmNuserData,he,NULL);


   XtManageChild(dialog);
/*   XWarpPointer(XtDisplay(he->textarea),XtWindow(he->textarea),
		XtWindow(XmSelectionBoxGetChild(dialog,XmDIALOG_TEXT)),
		0,0,800,800,0,0);*/
}

void load_net(Widget w,
		    XtPointer client_data,
		    XmSelectionBoxCallbackStruct *cbs)
{
   HTMLED *he=NULL;
   char command[STR_LEN];
   char url_file[STR_LEN];
   char *ptr = NULL;

   XtVaGetValues(w,XmNuserData,&he,NULL);
   if (he)
      ptr = he->Name_File;
   else
      return;

   if (ptr[0]!='/')
   {
      getwd(url_file);
      strcat(url_file,"/");
      strcat(url_file,ptr);
   }
   else
      strcpy(url_file,ptr);

   ptr = url_file;

   strcpy(command,"netscape -remote 'openFile(");
   strcat(command,ptr);
   strcat(command,")'");

   system(command);

}

void reload_net(Widget w,
		    XtPointer client_data,
		    XmSelectionBoxCallbackStruct *cbs)
{
   Widget dialog = XtNameToWidget(XtParent(w),"NETdialog");
   char command[STR_LEN];
   strcpy(command,"netscape -remote 'reload()'");
   system(command);
   XtUnmanageChild(dialog);
}
   








