/***********************************************************************
 * ext2spice
 * Converts circuits from .ext form to .spice form, including area and
 * perimeter of source and drain.
 * Copyright (c) 1987 
 * Andrew Burstein
 * 8/28/89 - Monte Mar.  Modified to read 2 poly caps.  
 *************************************************************************/
#include "ext2spice.h"
#include <math.h>
#include <sys/types.h>
#include <sys/dir.h>
#include <pwd.h>
#include <stdio.h>


	

/*  Read the .ext file corresponding to the current cell.
 *  Input scales.
 *  Input resistors and capacitors.
 *  Input nodes.
 *  Merge nodes when the .ext file says to.
 */
ReadExt(ExtFile,AlFile, FirstTrans, FirstCapac, TypeFirst,UFFirst)
  FILE *ExtFile,*AlFile;
  FET  **FirstTrans;
  CAP  **FirstCapac;
  FETTYPE *TypeFirst;
  USEDNUM *UFFirst;
{

  char  *ss, ch, buf[256];
  char  *Word[256];
  char  *ARestOfPath, *BRestOfPath, AArrayID[256], BArrayID[256];
  char  NodeID[256], NpID[256], *Nodech1, *Npch1, *Nodech2, *Npch2;
  char  First[256];
  int   AXlo, AXhi, AYlo, AYhi, BXlo, BXhi, BYlo, BYhi;
  int   i, j;
  int   Count;
  FET   *Trans;
  CAP   *Capac;
  FETTYPE *FTp;
  NODE  *Node, *Np;
  double CScale, LScale, dbl;
  USEDNUM  *UFp, *UFtemp;

  CScale = LScale = 0;
  while (fgets(buf,256,ExtFile) != NULL)  {
    Parse(buf, &Count, &(Word[0]));
    ch = Word[0][0];
    switch(ch)  {
      case 'n':  /* Keyword node  */
        FindNode(Word[1], &Node);
	if (sscanf (Word[3], "%lf", &dbl) == 1)
	  Node->Cap += CScale * dbl;
	if (sscanf (Word[4+(2 * PRClass)], "%lf", &dbl) == 1)
	  Node->PA += dbl * LScale * LScale;
	if (sscanf (Word[5+(2 * PRClass)], "%lf", &dbl) == 1)
          Node->PP += dbl * LScale;
	if (sscanf (Word[4+(2 * NRClass)], "%lf", &dbl) == 1)
          Node->NA += dbl * LScale * LScale;
	if (sscanf (Word[5+(2 * NRClass)], "%lf", &dbl) == 1)
          Node->NP += dbl * LScale;
        break;
      case 'e':  /*Keyword equiv */
	if (!strcmp(Word[0],"equiv") && (Count == 3)) {
	  fprintf(AlFile,"= %s %s \n",Word[1],Word[2]);
	  /* Create nodes for both names and merge the second to the first */
	  FindNode(Word[2],&Node);
	  FindNode(Word[1],&Np);
	  if ( Np != Node)  {
	    Node->Merge = Np;
	  }
	  if (Node->NodeNum != -1)  {
	    Np->NodeNum = Node->NodeNum;
	  }
	}
	break;
      case 'f':  /*Keyword fet */
	if (!strcmp(Word[0],"fet") && (Count >= 18)) {
	  /* Make sure the fet model is one of the defined models  */
	  FTp = TypeFirst;
	  while ((FTp != NULL) && (strcmp(FTp->ExtName,Word[1])))  {
	    FTp = FTp->Next;
	  }
	  if (FTp == NULL)  {
	    fprintf(stderr,"Skipping unknown fet type: %s \n",Word[1]);
	    break;
	  }
	  Trans = (FET *) calloc(1,sizeof(FET));
	  Trans->Next  = *FirstTrans;
	  *FirstTrans = Trans;
	  Trans->Model = FTp;
	  if (sscanf (Word[10], "%lf", &dbl) == 1)
	    Trans->L = LScale * dbl / 2 ;
	  if (sscanf (Word[13], "%lf", &dbl) == 1)
	    Trans->W = LScale * dbl ;
	  FindNode(Word[8], &(Trans->Sub));
	  FindNode(Word[9], &(Trans->Gate));
	  FindNode(Word[15], &(Trans->Source));
	  if (*Trans->Model->Flavor  == 'p')  {
	    if (sscanf (Word[16], "%lf", &dbl) == 1)
	      Trans->Source->PP -= dbl * LScale;
	    Trans->Source->PTotalW += Trans->W;
	  }  
	  else {
	    if (sscanf (Word[16], "%lf", &dbl) == 1)
	      Trans->Source->NP -= dbl * LScale;
	    Trans->Source->NTotalW += Trans->W;
	  }  
	  FindNode(Word[12], &(Trans->Drain));
	  if (*Trans->Model->Flavor == 'p')  {
	    if (sscanf (Word[13], "%lf", &dbl) == 1)
	      Trans->Drain->PP -= dbl * LScale;
	    Trans->Drain->PTotalW += Trans->W;
	  }  
	  else {
	    if (sscanf (Word[13], "%lf", &dbl) == 1)
	      Trans->Drain->NP -= dbl * LScale;
	    Trans->Drain->NTotalW += Trans->W;
	  }  
	}
	else {
	  fprintf(stderr,"skipping problem fet line in .ext file:\n%s\n",buf);
	  break;
	  }
	/* Assign an M# if one is specified as the gate atribute  */
	if (Word[11][0] == 'M')  {
	  /* Even though the name might not be an int, put it through
	   * atoi anyway.  Whatever comes out, we won't reuse that int,
	   * but we will output the string name
	   */
	  Trans->FetNum = atoi((Word[11])+1);
	  strcpy(Trans->FetName, (Word[11]+1));
	  UFp = UFFirst;
	  while((UFp->Next != NULL) && (UFp->Next->NodeNum <= Trans->FetNum)) { 
	    UFp = UFp->Next;
	  }
	  if (UFp->NodeNum != Trans->FetNum)  {/*No need to make a new UsedNum
			        *if number is already used    */
	    UFtemp = (struct UsedNum *) calloc(1, sizeof(struct UsedNum));
	    UFtemp->NodeNum = Trans->FetNum;
	    UFtemp->Next = UFp->Next;
	    UFp->Next = UFtemp;
	  }
	}
	else Trans->FetNum = -1;
	/* switch source and drain if they are backwards from attributes  */
	if ((Word[17][0] == 'D') || (Word[14][0] == 'S'))  {
	  Node = Trans->Drain;
	  Trans->Drain = Trans->Source;
	  Trans->Source = Node;
	}
	break;
      case 'c': /*Keyword cap */
	if ((!strcmp(Word[0],"cap")) && (Count == 4)) {
	  Capac = (CAP *) calloc(1,sizeof(CAP));
	  Capac->Next = *FirstCapac;
	  *FirstCapac = Capac;
	  /* Nodes that end in '!' are identified only by the final part
	   * of their hierachical names, since they are global nodes      
	   */
	  if (*(Word[1] + strlen(Word[1]) - 1) == '!') 
	      if (ss = strrchr(Word[1],'/'))
		Word[1] = ++ss;
	  FindNode(Word[1],&(Capac->Node1));

	  if (*(Word[2] + strlen(Word[2]) - 1) == '!') 
	      if (ss = strrchr(Word[2],'/'))
		Word[2] = ++ss;
	  FindNode(Word[2],&(Capac->Node2));
	  if (sscanf (Word[3], "%lf", &dbl) == 1)
	    Capac->Value =  CScale * dbl;
	}
	else {
	  fprintf(stderr,"skipping problem cap line in .ext file:\n%s\n",buf);
	  }
	break;
      case 'u': /* Keyword use */
	break;
      case 'm':  /* Keyword merge */
	if (!strcmp(Word[0],"merge"))  {
	  StripPath(Word[1],First,&ARestOfPath);
	  ArrayRange(First,AArrayID,&AXlo,&AXhi,&AYlo,&AYhi);
	  /*  Expand the special notation in .ext used to describe connections
	   *  within arrays.
	   */
	  StripPath(Word[2],First,&BRestOfPath);
	  ArrayRange(First,BArrayID,&BXlo,&BXhi,&BYlo,&BYhi);
	  for (i=AXlo; i<=AXhi; i++)  {
	    strcpy(NodeID,AArrayID);
	    strcpy(NpID,BArrayID);
	    Nodech1 = NodeID + strlen(NodeID);
	    Npch1 = NpID + strlen(NpID);
	    if (AXlo != -1 ) sprintf(Nodech1,"[%d]",i);
	    if (BXlo != -1)  sprintf(Npch1,"[%d]",(i+ BXlo - AXlo));
	    Nodech2 = NodeID + strlen(NodeID);
	    Npch2 = NpID + strlen(NpID);
	    for (j=AYlo; j<=AYhi; j++)  {
	      if (AYlo != -1 ) sprintf(Nodech2,"[%d]",j);
              if (BYlo != -1)  sprintf(Npch2,"[%d]",(j+ BYlo - AYlo));
	      if (*AArrayID != '\0') strcat(NodeID,"/");
	      if (*BArrayID != '\0') strcat(NpID,"/");
	      strcat(NodeID,ARestOfPath);
	      strcat(NpID,BRestOfPath);
	      FindNode(NodeID,&Node);
	      FindNode(NpID,&Np);
	      if ( Np != Node)  {
	        /* If one node is from this cell, it should be the target of
	         * the merge   */
	        if (( *BArrayID == '\0')&&(!strrchr(NpID,'#'))) {
		  MergeNodes(Np, Node);
		}
	        else  MergeNodes(Node,Np);
	      }
	    }
	  }
	}
	break;
      case 't':  /* Keyword tech or timestamp */
	if (!strcmp(Word[0],"tech")) {
	  if (*tech == '\0')  {  /* Only pay attention to the first tech line*/
	    strcpy(tech,Word[1]);
	  }
	}
	break;
      case 'v':  /* Keyword version */
	if (!strcmp(Word[0],"version"))  {
	}
	break;
      case 's':  /* Keyword scale */
	if ((!strcmp(Word[0],"scale")) && (Count == 4))  {
	  if (sscanf (Word[2], "%lf", &dbl) == 1)
	    CScale = dbl / 1000;
	  if (sscanf (Word[3], "%lf", &dbl) == 1)
	    LScale = dbl / 100;
	}
	else {
	  fprintf(stderr,"skipping scale line in %s:\n%s\n",ExtFile,buf);
	}
	break;
      case 'r':  /* Keyword resistclass  */
	if (!strcmp(Word[0],"resistclass"))  {
	  break;
	}
      case '*':  /* ignore comment  */
      case ' ':  /* ignore blank    */
	break;
      default:
	fprintf(stderr,"couldn't understand line in .ext File:\n%s\n",buf);
    }
  }
}


