#define TBLSIZE 512
#include <stdio.h>
#include <string.h>

typedef struct Cell
{
  struct Cell *Next, *Last;
  struct Instance *InstList;
  struct Terminal *TermList;
  struct Fet *FetList;
  struct Cap *CapList;
  struct UsedNum  *UsedNodeList;  /* List of used spice node numbers       */
  struct UsedNum  *UsedFetList;  /* List of used fet numbers (Mxxxx in spice)*/
  char  *PathName, *CellName;
} CELL;

typedef struct Terminal
{
  char *NodeName;
  char *Merge;
  struct Node *Node;
  struct Terminal *Next;
}  TERMINAL;

typedef struct Instance
{
  struct Cell *Cellp;
  struct Instance *Next;
  char *InstID;
}  INSTANCE;

typedef struct Node  {
  char *Name;
  int  NodeNum;
  double PTotalW, NTotalW;
  struct Node *Merge;
  double NA, NP, PA, PP;
  double Cap;
  struct Node *Next;
  }  NODE;

typedef struct Fet  {
  NODE *Gate, *Drain, *Source, *Sub;
  double L, W;
  struct FetType *Model;
  struct Fet *Next;
  int  FetNum;
  char FetName[16];
  } FET;

typedef struct Cap   {
  NODE *Node1, *Node2;
  double Value;
  struct Cap *Next;
}  CAP;
 
typedef struct FetType {
  char ExtName[32];
  char SpiceName[32];
  char Flavor[8];  /*  either "n" or "p"   */
  struct FetType *Next;
} FETTYPE;
 
typedef struct UsedNum  {  /* A node or FET number already used in defs file  */
  int NodeNum;
  struct UsedNum *Next;
} USEDNUM;
 
NODE *NodeTable[TBLSIZE];

CELL *CellFirst;
 
char tech[32];
 
int PRClass, NRClass; 

float areacap;
