#include "ext2spice.h" 
#include <ctype.h>


/*  Create a Cell for each cell that is used in the ExtFile.  Then go
 *  through the .ext file of each cell in turn, looking for more cells
 */
GetCells(Path)
  char  **Path;
{
  char   *Word[256];
  int    Count;
  int    i, j, Xlo, Xhi, Ylo, Yhi;
  char   buf[256], *ch1, *ch2;
  char   First[256], *RestOfPath;
  char   InstID[256], ArrayID[256];
  char   *FindPath();
  CELL   *RootCell, *SubCell, *FindCell(), *ID2Cell();
  INSTANCE  *Inst, *MakeInstance();
  FILE   *ExtFile;
  TERMINAL *Term, *FirstBang;
  extern CELL *CellFirst;

  FirstBang = NULL;

  /* Find all Cells and cell instances */
  for (RootCell = CellFirst; RootCell != NULL; RootCell= RootCell->Next)  {
    RootCell->PathName = FindPath(RootCell->CellName,Path);
    OpenFile(&ExtFile,RootCell->PathName,"r");
    printf("Reading from file %s\n",RootCell->PathName);
    while (fgets(buf,256,ExtFile) != NULL)  {
      Parse(buf, &Count, &(Word[0]));
      /* Keyword use   */
      if (!strcmp(Word[0],"use"))  {
	SubCell = FindCell(Word[1],RootCell);
	ArrayRange(Word[2],ArrayID,&Xlo,&Xhi,&Ylo,&Yhi);
	strcpy(First,ArrayID);
	ch1 = First + strlen(First);
	for (i=Xlo; i<=Xhi; i++)  {
	  if  ((Xlo != -1) && (Xhi != Xlo))  {
	    sprintf(ch1,"[%d]",i);
	  }
	  ch2 = First + strlen(First);
	  for (j=Ylo; j<=Yhi; j++)  {
	    if  ((Ylo != -1 ) && (Yhi != Ylo))  {
	      sprintf(ch2,"[%d]",j);
	    }
            Inst = MakeInstance(RootCell,SubCell,First);
	  }
	}
      }
    }
    fclose(ExtFile);
  }
  /* Find all the terminals of all the cells */
  for (RootCell = CellFirst; RootCell != NULL; RootCell= RootCell->Next)  {
    OpenFile(&ExtFile,RootCell->PathName,"r");
    while (fgets(buf,256,ExtFile) != NULL)  {
      Parse(buf, &Count, &(Word[0]));
      /* Keyword node  */
      if (!strcmp(Word[0],"node"))  {
	AddBang(Word[1],&FirstBang);
      }
      else if (!strcmp(Word[0],"merge") || (!strcmp(Word[0],"cap")))    {
	StripPath(Word[1],First,&RestOfPath);
	if (*First != '\0')  {
  	  SubCell = ID2Cell(First,RootCell);
	  AddTerm(SubCell,RestOfPath);
	}
	StripPath(Word[2],First,&RestOfPath);
	if (*First != '\0')  {
  	  SubCell = ID2Cell(First,RootCell);
	  AddTerm(SubCell,RestOfPath);
	}
      }
      else if (!strcmp(Word[0],"equiv"))  {
        AddBang(Word[1],&FirstBang);
        AddBang(Word[2],&FirstBang);
      }
    }
    fclose(ExtFile);
    /*  Since Vdd! and GND! are the substrate nodes for fet's (as defined
     *  in the magic technology file, make them terminals of all subckt's  
     */
    AddBang("Vdd!",&FirstBang);
    AddBang("GND!",&FirstBang);
  }
  /* Make any node ending in '!' a terminal */
  for (RootCell = CellFirst; RootCell != NULL; RootCell = RootCell->Next)  {
    for (Term = FirstBang; Term != NULL; Term = Term->Next)  {
      AddTerm(RootCell,Term->NodeName);
    }
  }
}

/*  Expand the special array notation used in .ext
 */
ArrayRange(Name,ArrayID,Xlo,Xhi,Ylo,Yhi)
  char *Name, *ArrayID;
  int  *Xlo, *Xhi, *Ylo, *Yhi;
{
  char *ch, buf[256];

  *buf = '\0';
  for (ch = Name; (*ch != '[')&&(*ch != '\0'); ch++);
  strncpy(ArrayID,Name,(ch - Name));
  *(ArrayID + (ch - Name)) = '\0';
  if (*ch == '[')  {  /* Find Xlo  */
    while ( isdigit(*(++ch)))  strncat(buf,ch,1);
    *Xlo = atoi(buf);
    if (*ch == ':')  {  /* Find Xhi  */
      *buf = '\0';
      while ( isdigit(*(++ch)))  strncat(buf,ch,1);
      *Xhi = atoi(buf);
    }
    else  *Xhi = *Xlo;
    for (ch; (*ch != '[')&&(*ch != ',')&&(*ch != '\0'); ch++);
    if ((*ch == '[') ||(*ch == ',')) {  /* Find Ylo  */
      *buf = '\0';
      while ( isdigit(*(++ch)))  strncat(buf,ch,1);
      *Ylo = atoi(buf);
      if (*ch == ':')  {  /* Find Yhi  */
        *buf = '\0';
        while ( isdigit(*(++ch)))  strncat(buf,ch,1);
        *Yhi = atoi(buf);
      }
      else  *Yhi = *Ylo;
    }
    else *Yhi = *Ylo = -1;
  }
  else *Xhi = *Xlo = *Yhi = *Ylo = -1;
}


/*  change Name from an instance ID to a cell name and return a pointer
 *  to the cell
 */
CELL * ID2Cell(Name,RootCell)
  char *Name;
  CELL *RootCell;
{
  char InstanceID[256], *ch;
  INSTANCE  *instp;
  int  Xlo, Xhi, Ylo, Yhi;

  /* if it's an array, just pick the first instance name of the array;
   *  they all come from the same cell anyway  */
  ArrayRange(Name, InstanceID, &Xlo, &Xhi, &Ylo, &Yhi);
  ch = InstanceID + strlen(InstanceID);
  if (Xlo != -1)  sprintf(ch,"[%d]",Xlo);
  ch = InstanceID + strlen(InstanceID);
  if (Ylo != -1)  sprintf(ch,"[%d]",Ylo);
  for (instp = RootCell->InstList; instp; instp = instp->Next)  {
    if (!strcmp(InstanceID, instp->InstID))  {
      return(instp->Cellp);
    }
  }
  fprintf(stderr,"Error: expected to find instance: %s in cell %s \n",
    InstanceID,RootCell->CellName);
  exit(1);
}


/*  Nodes in subcells are identified by giving the path through the 
 *  cells in '/'s and then the node name.
 *  Make First contain the top level subcell name, or be blank if the
 *  node is already in the current cell.  Make RestOfPath point to the
 *  place in Path after the end of the top level cell name.
 *  Doesn't change contents of Path.
 *  Changes contents of First.
 */
StripPath(Path,First,RestOfPath)
  char *Path, *First, **RestOfPath;
{
  char *ch;

  if (*(Path + strlen(Path) - 1) == '!')  {
    ch = strrchr(Path,'/');
    if (ch == NULL)  {
      *RestOfPath = Path;
    }
    else {
      *RestOfPath = ++ch;
    }
    strcpy(First,"");
  }
  else  {
    ch = strchr(Path,'/');
    if (ch == NULL)  {
      strcpy(First,"");
      *RestOfPath = Path;
    }
    else {
      strncpy(First,Path,(ch - Path)); *(First + (ch - Path)) = '\0';
      *RestOfPath = ++ch;
    }
  }  
}

/*  Update BangList, a list of node names that end in '!'.  If Name ends
 *  in '!', add it to the BangList, if it is not already present
 */
AddBang(Name,BangList)
  char *Name;
  TERMINAL **BangList;
{
  TERMINAL  *Term;

  if (strchr(Name,'!') != NULL)  {
    for (Term = *BangList; (Term!=NULL)&&(strcmp(Term->NodeName,Name));
         Term = Term->Next);
    if (Term == NULL)  {
      Term = (TERMINAL *) calloc(1,sizeof(TERMINAL));
      Term->NodeName = (char *) calloc(1,strlen(Name) + 1);
      strcpy(Term->NodeName,Name);
      Term->Next = *BangList;
      *BangList = Term;
    }
  }
}


INSTANCE *MakeInstance(ThisCell,SubCell,InstID)
  CELL *ThisCell, *SubCell;
  char *InstID;
{
  INSTANCE  *Inst;

  Inst = (INSTANCE *)  calloc(1,sizeof(INSTANCE));
  Inst->Cellp = SubCell;
  Inst->Next = ThisCell->InstList;
  Inst->InstID = (char *) calloc(1,strlen(InstID) +1);
  strcpy(Inst->InstID,InstID);
  ThisCell->InstList = Inst;
  return(Inst);
}



/*  If the Cell doesn't already have the terminal, NodeName, add it to 
 *  its list of terminals, and increment its terminal count
 */
AddTerm(Cellp,TermName)
  char *TermName;
  CELL *Cellp;
{
  TERMINAL  *Termp;

  for(Termp=Cellp->TermList;(Termp != NULL)&&(strcmp(Termp->NodeName,TermName));
      Termp = Termp->Next);
  if (Termp == NULL)  {
    Termp = (TERMINAL *) calloc(1,sizeof(TERMINAL));
    Termp->NodeName = (char *) calloc(1,strlen(TermName) + 1);
    strcpy(Termp->NodeName, TermName);
    Termp->Node = NULL;
    Termp->Next = Cellp->TermList;
    Cellp->TermList = Termp;
  }
}
   
/*  Insert cell CellID into Cell list.  Move it to a position after its
 *  Parent, if it is not already after its parent   
 */
CELL *FindCell(CellID, Parent)
  char  *CellID;
  CELL  *Parent;
{

  CELL   *Cellp;
  extern CELL *CellFirst;
  int   BeforeParent;

  BeforeParent = 1;
  Cellp = CellFirst;
  while ((Cellp->Next != NULL) && (strcmp(Cellp->CellName,CellID)))  {
    if (Cellp == Parent) BeforeParent = 0;
    Cellp = Cellp->Next;
  }
  if (strcmp(Cellp->CellName,CellID))  { /*  If it isn't already there, make
					  *  new cell and put at end of list */
    Cellp->Next = (CELL *)  calloc(1,sizeof(CELL));
    Cellp->Next->Last = Cellp;
    Cellp = Cellp->Next;
    Cellp->CellName = (char *) calloc(1,strlen(CellID) + 1);
    strcpy(Cellp->CellName,CellID);
    Cellp->Next = NULL;
    Cellp->InstList = NULL;
    Cellp->TermList = NULL;
    Cellp->FetList = NULL;
    Cellp->CapList = NULL;
    Cellp->UsedFetList = (struct UsedNum *) calloc(1, sizeof(struct UsedNum));
    Cellp->UsedFetList->NodeNum =0;
    Cellp->UsedFetList->Next = NULL;
    Cellp->UsedNodeList =(struct UsedNum *) calloc(1, sizeof(struct UsedNum));
    Cellp->UsedNodeList->NodeNum =0;
    Cellp->UsedNodeList->Next = NULL;

  }
  else if (BeforeParent)  {  /* Cut   */
    Cellp->Last->Next = Cellp->Next;
    Cellp->Next->Last = Cellp->Last;
    /*  Paste after Parent  */
    Cellp->Next = Parent->Next;
    Parent->Next = Cellp;
    Cellp->Last = Parent;
    if (Cellp->Next != NULL)  Cellp->Next->Last = Cellp;
  }
  return(Cellp);
}


/*  Find the full path name of the .ext file from the cell name   */
char *FindPath(CellID,Path)
  char   *CellID;
  char   **Path[];
{
  char  *FilePath;
  int   i;
  FILE  *File;

  FilePath = (char *) calloc(256,sizeof(char));
  for (i=0; (*Path)[i] != '\0'; i++)  {
    strcpy(FilePath,Path[i]);
    strcat(FilePath,CellID);
    strcat(FilePath,".ext");
    if (File = (fopen(FilePath,"r")))  {
      fclose(File);
      return(FilePath);
    }
    else {
    /*fclose(File)*/;
    }
  }
  strcpy(FilePath,CellID);
  strcat(FilePath,".ext");
  return(FilePath);
}



