/*
 * @(#)$Id: zyxel.c,v 1.1 1993/01/06 18:17:28 wcp Exp $
 *
 * Copyright (C) 1993	Walter Pelissero
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Log: zyxel.c,v $
 * Revision 1.1  1993/01/06  18:17:28  wcp
 * Initial revision
 *
 */

#include <string.h>
#include "common.h"
#include "modemio.h"
#include "zyxel.h"

static char RcsId[] = "@(#)$Id: zyxel.c,v 1.1 1993/01/06 18:17:28 wcp Exp $";

const char *ModemAnswers[] = {
  "ERROR",
  "OK",
  "RING",
  "CONNECT 1200",
  "CONNECT 2400",
  "CONNECT 4800",
  "CONNECT 9600",
  "CONNECT 19200",
  "CONNECT 7200",
  "CONNECT 12000",
  "CONNECT 14400",
  "CONNECT 16800",
  "CONNECT 38400",
  "CONNECT 57600",
  "CONNECT 76800",
  "CONNECT",
  "NO CARRIER",
  "NO DIAL TONE",
  "BUSY",
  "NO ANSWER",
  "+FCON",
  "+FDCS:",
  "+FDIS:",
  "+FCFR",
  "+FTSI:",
  "+FCSI:",
  "+FPTS:",
  "+FET:",
  "+FHNG:",
  "VCON",
  0
};

short C2_resolution = -1, C2_baud = -1, C2_width, C2_length, C2_compression;
short C2_errCorr, C2_eop = -1;
char C2_caller[30] = "";

ModemReturnCode receive(unsigned t, int fd)
{
  ModemReturnCode ret;

  if (mdread(t, fd, ModemAnswers, &ret))
    {
      switch (ret)
	{
	  char *p;
	  static char sep[] = ", ";

	case MDFDCS:
	  p = strstr(mdread_buffer, "+FDCS:") + strlen("+FDCS:");
	  *strpbrk(p, "\r;\n") = '\0'; /* null terminate */
	  C2_resolution = atoi(strtok(p, sep));
	  C2_baud = atoi(strtok(0, sep));
	  C2_width = atoi(strtok(0, sep));
	  C2_length = atoi(strtok(0, sep));
	  C2_compression = atoi(strtok(0, sep));
	  C2_errCorr = atoi(strtok(0, sep));
	  break;
	case MDFDIS:
	case MDFCFR:
	  break;
	case MDFTSI:
	  p = strstr(mdread_buffer, "+FTSI:") + strlen("+FTSI:");
	  *strchr(p, '\r') = '\0';
	  strncpy(C2_caller, p, sizeof(C2_caller));
	  C2_caller[sizeof(C2_caller) - 1] = '\0';
	  break;
	case MDFCSI:
	case MDFPTS:
	  break;
	case MDFET:
	  p = strstr(mdread_buffer, "+FET:") + strlen("+FET:");
	  *strpbrk(p, "\r,;\n") = '\0';
	  C2_eop = atoi(p);
	  break;
	case MDFHNG:
	case MDVCON:
	default:
	  break;
	}
      return ret;
    }
  return MDERROR;
}
