/*
 * @(#)$Id: voice.c,v 1.1 1993/01/06 18:14:13 wcp Exp $
 *
 * Copyright (C) 1993	Walter Pelissero
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Log: voice.c,v $
 * Revision 1.1  1993/01/06  18:14:13  wcp
 * Initial revision
 *
 */

#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include <stdlib.h>
#include "voice.h"

static char RcsId[] = "@(#)$Id: voice.c,v 1.1 1993/01/06 18:14:13 wcp Exp $";

extern const char *myname;

bool setLine(Port port)
{
  struct termio tty_settings;

  if (ioctl(port.outfd, TCGETA, &tty_settings) < 0)
    {
      fprintf(stderr, "%s: can't ioctl()\n", myname);
      return FALSE;
    }
  tty_settings.c_iflag &= ~(BRKINT | ICRNL | ISTRIP);
  tty_settings.c_iflag |= IXON | IXANY;
  tty_settings.c_cflag &= ~(PARENB | CBAUD);
  tty_settings.c_cflag |= HUPCL | CSIZE | CS8 | CREAD | B38400;
  tty_settings.c_cflag |= CRTSCTS | CLOCAL;
  tty_settings.c_lflag &= ~(ISIG | ECHO | ICANON);
  tty_settings.c_cc[VMIN] = 1;
  tty_settings.c_cc[VTIME] = 0;
  tty_settings.c_oflag &= ~OPOST;
  if (ioctl(port.outfd, TCSETAF, &tty_settings) < 0)
    {
      fprintf(stderr, "%s: can't prepare line settings\n", myname);
      return FALSE;
    }
  return TRUE;
}

Port openLine(const char *portname)
{
  Port port, bad;
  struct termio	tty_settings;

  port.infd = port.outfd = bad.infd = bad.outfd = -1;
  errno = 0;
  if ((port.infd = open(portname, (O_RDONLY | O_NDELAY))) < 0 ||
      (port.outfd = open(portname, (O_WRONLY | O_NDELAY))) < 0)
    {
      if (errno == EBUSY)
	fprintf(stderr, "%s: port %s BUSY\n", myname, portname);
      else
	fprintf(stderr, "%s: can't connect into %s (%s)\n", myname,
		portname, sys_errlist[errno]);
      return bad;
    }
  if (ioctl(port.outfd, TCGETA, &tty_settings) < 0)
    {
      fprintf(stderr, "%s: can't ioctl()\n", myname);
      return bad;
    }
  port.orig_tty_settings = tty_settings;
  if (ioctl(port.outfd, TCSETAF, &tty_settings) < 0)
    {
      fprintf(stderr, "%s: can't prepare line settings\n", myname);
      return bad;
    }
  if (!setLine(port))
    {
      fprintf(stderr, "%s: cannot prepare line settings\n", myname);
      return bad;
    }
  if (fcntl(port.infd, F_SETFL, O_RDONLY) == ERROR ||
      fcntl(port.outfd, F_SETFL, O_WRONLY) == ERROR)
    {
      fprintf(stderr, "%s: can't unset O_NDELAY for %s\n", myname, portname);
      return bad;
    }
  return port;
}

bool resetLine(Port p)
{
  if (ioctl(p.outfd, TCSETAF, &p.orig_tty_settings) < 0)
    {
      fprintf(stderr, "%s: can't restore line settings\n", myname);
      return FAILED;
    }
  return TRUE;
}

bool closeLine(Port p)
{
  resetLine(p);
  close(p.infd);
  close(p.outfd);
  return TRUE;
}
