/*
 * $Id: temp.c,v 1.1 1993/01/06 18:13:18 wcp Exp $
 *
 * Copyright (C) 1992	Walter Pelissero
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Log: temp.c,v $
 * Revision 1.1  1993/01/06  18:13:18  wcp
 * Initial revision
 *
 * Revision 1.1  1992/07/07  17:27:24  wally
 * Initial revision
 *
 */

#include <sys/types.h>
#include <malloc.h>
#include <string.h>
#include <stdio.h>
#include "common.h"

static char RcsId[] = "$Id: temp.c,v 1.1 1993/01/06 18:13:18 wcp Exp $";

char *makeTemp(const char *directory)
{
  char *pathname;
  unsigned i = 0;

  if (!directory)
    directory = TMP_DIR;
  pathname = malloc(strlen(directory) + 64);
  do
    sprintf(pathname, "%s/fx%u-%u", directory, getpid(), i++);
  while (access(pathname, 0) == 0);
  return pathname;
}
