#
# $Id: zyxel5cb.tcl,v 1.3 1993/01/21 19:35:49 wcp Exp $
#
# Copyright (C) 1992	Walter Pelissero
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 1, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

#
# $Log: zyxel5cb.tcl,v $
# Revision 1.3  1993/01/21  19:35:49  wcp
# Modified documentation; Added support for different, previosly
# unexpected, return strings when dialing back.
# Added a "default" sequence of commands in case of unexpected
# return code of record.
#
# Revision 1.2  1993/01/13  21:38:47  wcp
# Changed to use the new "invoke" command.
#
# Revision 1.1  1993/01/07  23:22:05  wcp
# Initial revision
#
#

#
# Mgetty tcl startup script for ZyXEL U1496 modems with ROMs 5.xx
# supporting voice, modem, and fax connections and "blind" call-back.
#

set LOCAL_NUMBER "+39-2-8435411"	;# the local fax number
set LIBDIR /usr/local/lib/mgetty
set CLASS2_RECEIVER $LIBDIR/c2rec
set RECORDER $LIBDIR/record
set PLAYER $LIBDIR/play
set SOUND $LIBDIR/sound
set ANRING 3				;# number of rings to answer
# this is the call-back string: it must contain all the parameter
# settings one may need plus a "D" character preceding the phone number
set CBNUMBER "&N16D82,67089"		;# example: set V.21 and dial

baudrate 38400
send "ATZ\r"
sleep 2
send "ATE0Q0\r"
flush_input
send "ATPV1X7S0=0S7=60&B0&C1&D3&N0S39.4=1S38.4=0S41.7=0\r"
if { [receive 2 OK] == "" } { exit }
send "ATM0+FCLASS=2;+FBOR=0;+FCR=1;+FLID=\"$LOCAL_NUMBER\"\r"
if { [receive 2 OK] == "" } { exit }
send "AT+FDCC=1,5,0,2,0,0,0\r"
if { [receive 2 OK] == "" } { exit }

send "AT+FCLASS=8\r"			;# set in voice mode
if { [receive 2 OK] == "" } { exit }
#
# Wait an incoming call
#
if { [listen] != "RING" } { exit }
set rings 1
set phase 1
while { $rings < $ANRING } {
      if { [receive 10 RING] == "" } {
	 if { $phase == 2 } {
	    flush_input
	    send "AT&B1+FCLASS=0;$CBNUMBER\r"
	    case [receive [expr {[string length $CBNUMBER] * 3 + 60}] CONNECT BUSY "NO CARRIER" "NO ANSWER"] in {
		 { CONNECT } {
	 	   sleep 2
		   login
		   exit 1
		 }
		 default { exit 1 }
	    }
	 }
	 if { [receive 20 RING] == "" } { exit }
	 set phase [expr {$phase + 1}]
	 set rings 1
      } else { set rings [expr {$rings + 1}] }
}

#
# Someone is ringing, let's listen to him/her
#
send "AT+VSM=2;+VBT=2;+VSD=20,30\r"
if { [receive 2 OK] == "" } { exit }
send "AT+VLS=2\r"
if { [receive 2 VCON] == "" } { exit }

sleep 1
invoke $PLAYER $SOUND/greetings		;# Give a greeting message...
send "AT+VTS=\[1355,0,5\]\r"		;# ...and end it with a beep.
if { [receive 5 OK] == "" } { exit }

# start recording
case [invoke $RECORDER -t 7:60 /usr/spool/voice] in {
     { 0 } {
       #
       # Message has been recorded succesfully.
       # (also if time expired)
       #
       send "AT+VTS=\[955,0,10\]\r"
       if { [receive 5 OK] == "" } { exit }
       invoke $PLAYER $SOUND/salutations
       send "AT+VLS=0\r"
       if { [receive 2 OK] == "" } { exit }
       send "AT+FCLASS=0\r"
       if { [receive 2 OK] == "" } { exit }
       send "ATZ\r"
       sleep 2
       exit
     }
     { 1 } {
       #
       # Got silence. It may be a modem or someone who
       # hanged without talking.
       #
       send "AT+FCLASS=0\r"
       if { [receive 2 OK] == "" } { exit }
       send "ATA\r"
       set buffer [receive 60]
       case $buffer in {
	    { "CONNECT 1200*" } { baudrate 1200 }
	    { "CONNECT 2400*" } { baudrate 2400 }
	    { "CONNECT 4800*" } { baudrate 4800 }
	    { "CONNECT 9600*" } { baudrate 9600 }
	    { "CONNECT 19200*" } { baudrate 19200 }
	    { "CONNECT 7200*" } { baudrate 7200 }
	    { "CONNECT 12000*" } { baudrate 12000 }
	    { "CONNECT 14400*" } { baudrate 14400 }
	    { "CONNECT 16800*" } { baudrate 16800 }
	    { "CONNECT 38400*" } { baudrate 38400 }
	    { "CONNECT 57600*" } { baudrate 57600 }
	    { "CONNECT 76800*" } { baudrate 76800 }
	    { "NO CARRIER*" } { exit }
	    default { exit }
       }
       login
       exit 1       
     }
     { 2 } {
       #
       # Received a T.30 fax tone.
       #
       baudrate 19200
       send "AT+FCLASS=2;+FAA=0\r"
       if { [receive 2 OK] == "" } { exit }
       send "ATA\r"
       if { [receive 20 +FCON] == "" } { exit }
       invoke $CLASS2_RECEIVER -p /usr/spool/fax
       exit
     }
     default {
       #
       # Got a busy signal too soon or there was problems during recording
       #
       send "AT+VLS=0\r"
       if { [receive 2 OK] == "" } { exit }
       send "AT+FCLASS=0\r"
       if { [receive 2 OK] == "" } { exit }
       send "ATZ\r"
       sleep 2
       exit
     }
}
