#
# $Id: zyxel4.tcl,v 1.3 1993/01/21 19:33:18 wcp Exp $
#
# Copyright (C) 1992	Walter Pelissero
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 1, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

#
# $Log: zyxel4.tcl,v $
# Revision 1.3  1993/01/21  19:33:18  wcp
# Changed buggy invocation of fax receiver.
#
# Revision 1.2  1993/01/13  21:37:24  wcp
# Removed unuseful options in CLASS2_RECEIVER and changed
# syntax to the new "invoke" command.
#
# Revision 1.1  1993/01/06  18:20:26  wcp
# Initial revision
#
#

#
# Mgetty tcl startup script for ZyXEL U1496 modems with ROMs 4.xx
# supporting modem and fax capabilities.
#

set LOCAL_NUMBER "+39-2-8435411"
set CLASS2_RECEIVER "/usr/local/lib/mgetty/c2rec"

baudrate 19200
send "ATZ\r"
sleep 2
send "ATE0Q0\r"
flush_input
send "ATPV1X6S0=1S7=60&B0&C1&D3&N0\r"
if { [receive 2 "OK"] != "OK" } { exit }
send "ATM0+FCLASS=2;+FAA=1;+FCR=1;+FBOR=0;+FLID=\"$LOCAL_NUMBER\"\r"
if { [receive 2 "OK"] != "OK" } { exit }
send "AT+FDCC=1,5,0,2,0,0,0\r"
if { [receive 2 "OK"] != "OK" } { exit }
set buffer ""
while { $buffer == "" } {
	set buffer [ listen ]
	case $buffer in {
		{ "CONNECT 1200*" } { baudrate 1200 }
		{ "CONNECT 2400*" } { baudrate 2400 }
		{ "CONNECT 4800*" } { baudrate 4800 }
		{ "CONNECT 9600*" } { baudrate 9600 }
		{ "CONNECT 19200*" } { baudrate 19200 }
		{ "CONNECT 7200*" } { baudrate 7200 }
		{ "CONNECT 12000*" } { baudrate 12000 }
		{ "CONNECT 14400*" } { baudrate 14400 }
		{ "CONNECT 16800*" } { baudrate 16800 }
		{ "CONNECT 38400*" } { baudrate 38400 }
		{ "CONNECT 57600*" } { baudrate 57600 }
		{ "CONNECT 76800*" } { baudrate 76800 }
		{ "+FCON*" } {
			baudrate 19200
			invoke $CLASS2_RECEIVER -p /usr/spool/fax
			exit
		}
		default { set buffer "" }
	}
}

# If we are not able to decipher what comes from tty it is probably
# time to give a try to getty
# mode remote cooked no_flow
login
