: use /bin/sh
#
# $Id: printfax.sh,v 1.3 1993/01/22 15:14:24 wcp Exp $
#
# Copyright (C) 1992	Walter Pelissero
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 1, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

#
# $Log: printfax.sh,v $
# Revision 1.3  1993/01/22  15:14:24  wcp
# Removed magic string.
#
# Revision 1.2  1993/01/07  23:18:00  wcp
# Corrected a test.
#
# Revision 1.1  1993/01/06  18:11:29  wcp
# Initial revision
#
#

PBMPLUS=%PBMPLUS%
G3TOPBM=$PBMPLUS/g3topbm
PNMSCALE=$PBMPLUS/pnmscale
PGMTOPBM=$PBMPLUS/pgmtopbm
PBMTOEPSON=$PBMPLUS/pbmtoepson
TMP=/tmp/pf$$

[ $# -ne 1 ] && {
	echo "usage: $0 base_name"
	exit 1
}

trap 'rm -f $TMP; exit 1' 1 2 3 4 5 6 7 8 9 10 12 14 15 16 17
(
page=0
for f in `ls -tr $1.*`
do
	[ "$f" = "$1.*" ] && break
	[ $page -eq 0 ] || echo "\f"
	caller=`sed -n '1,/^DATA:/s/^CALLER:[ \t]*\(.*\)/\1/p' $f`
	date=`sed -n '1,/^DATA:/s/^DATE:[ \t]*\(.*\)/\1/p' $f`
	resolution=`sed -n '1,/^DATA:/s/^RESOLUTION:[ \t]*\(.*\)/\1/p' $f`
	speed=`sed -n '1,/^DATA:/s/^SPEED:[ \t]*\(.*\)/\1/p' $f`
	page=`expr $page + 1`
	echo "Date: $date\tFrom: $caller"
	echo "Page: $page\r\t\t\t\tSpeed: $speed\t\tResolution: \c"
	tail +`awk '/^DATA:$/ { print NR + 1; exit }' $f` $f > $TMP
	if [ "$resolution" -eq 0 ]
	then
		echo LOW
		$G3TOPBM -big -delete -stretch $TMP | $PBMTOEPSON -triple -24pin
	else
		echo HIGH
		$G3TOPBM -big -delete $TMP | $PBMTOEPSON -triple -24pin
	fi
done
) | lp -s # -tFax
rm -f $TMP
