/*
 * $Id: locks.c,v 1.2 1993/01/06 18:06:04 wcp Exp $
 *
 * Copyright (C) 1992	Walter Pelissero
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Log: locks.c,v $
 * Revision 1.2  1993/01/06  18:06:04  wcp
 * Modified unlockLine() to be able to remove someone else locks.
 * Added ilLocked().
 *
 * Revision 1.1  1992/08/28  22:44:05  wally
 * Initial revision
 *
 */

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <stdlib.h>
#include <errno.h>
#include "common.h"

static char RcsId[] = "$Id: locks.c,v 1.2 1993/01/06 18:06:04 wcp Exp $";

bool unlockLine(const char *line)
{
  char *tty;
  char *pathname = malloc(strlen(LOCK_DIR) + strlen(line) + 7);
  int fd;
  bool ret = FAILED;

  tty = strdup(basename(line));
  strlower(tty);
  sprintf(pathname, "%s/LCK..%s", LOCK_DIR, tty);
  free(tty);
  fd = open(pathname, O_RDONLY);
  if (fd >= 0)
    {
      char buf[32];
      int nread;
      int pid;

      if ((nread = read(fd, buf, sizeof(buf))) > 0)
	{
#if defined(M_XENIX)
	  buf[nread - 1] = '\0';
	  pid = atoi(buf);
#else
	  memcpy(&pid, buf, sizeof(pid));
#endif
	}
      else
	pid = getpid();
      close(fd);
      if (pid == getpid() || kill(pid, 0) < 0)
	{
	  unlink(pathname);
	  ret = SUCCEEDED;
	}
      else
	ret = FAILED;
    }
  else
    ret = (errno == ENOENT);
  free(pathname);
  return ret;
}

bool lockLine(const char *line, int time)
{
  char *pathname1 = makeTemp(LOCK_DIR), *pathname2, *tty;
  int fd = open(pathname1, O_WRONLY | O_CREAT, 0644), ret = TRUE;

  if (fd < 0)
    return FALSE;
  else
    {
      char buf[32];
      int pid = getpid();

#if defined(M_XENIX)
      sprintf(buf, "%10u\n", pid);
      write(fd, buf, strlen(buf));
#else
      write(fd, &pid, sizeof(pid));
#endif
      close(fd);
    }
  tty = strdup(basename(line));
  strlower(tty);
  pathname2 = malloc(strlen(LOCK_DIR) + strlen(tty) + 7);
  sprintf(pathname2, "%s/LCK..%s", LOCK_DIR, tty);
  free(tty);
  while (link(pathname1, pathname2) < 0)
    {
      if (!unlockLine(line))
	{
	  sleep(10);
	  if ((time -= 10) <= 0)
	    {
	      ret = FALSE;
	      break;
	    }
	}
    }
  unlink(pathname1);
  free(pathname1);
  free(pathname2);
  return ret;
}

bool isLocked(const char *line)
{
  char pathname[strlen(LOCK_DIR) + strlen(line) + 7];
  int fd;
  bool ret = FALSE;

  sprintf(pathname, "%s/LCK..%s", LOCK_DIR, line);
  if ((fd = open(pathname, O_RDONLY)) >= 0)
    {
      int nread;
      char buf[30];

      if ((nread = read(fd, buf, sizeof(buf))) > 0)
	{
	  int pid;

#if defined(M_XENIX)
	  buf[nread - 1] = '\0';
	  pid = atoi(buf);
#else
	  memcpy(&pid, buf, sizeof(pid));
#endif
	  if (kill(pid, 0) == 0)
	    ret = TRUE;
	}
    }
  return ret;
}
