: use /bin/sh
#
# @(#)$Id: listen.sh,v 1.2 1993/01/22 15:14:24 wcp Exp $
#
# Copyright (C) 1993	Walter Pelissero
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

#
# $Log: listen.sh,v $
# Revision 1.2  1993/01/22  15:14:24  wcp
# Removed magic string.
#
# Revision 1.1  1993/01/07  23:16:09  wcp
# Initial revision
#
#

LIBDIR=%LIB_DIR%
PLAY="$LIBDIR/play"

flags=
for a in $*
do
	case $a in
	-*)	flags="$flags $a"
		shift; #=`eval $# - 1`
		;;
	*)	break
		;;
	esac
done

play () {
	encoding=`sed -n '1,/^DATA:/s/^ENCODING:[ \t]*\(.*\)/\1/p' $1`
	[ "$encoding" ] || encoding=2
	tail +`awk '/^DATA:$/ { print NR + 1; exit }' $1` $1 | $PLAY $flags -s $encoding
}

[ $# -lt 1 ] && set -- /usr/spool/voice/*

for f in $*
do
	if [ -d $f ]
	then
		for ff in $f/*
		do
			play $ff
		done
	else
		play $f
	fi
done
