/*
 * $Id: common.h,v 1.2 1993/01/15 23:04:26 wcp Exp $
 *
 * Copyright (C) 1992	Walter Pelissero
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Log: common.h,v $
 * Revision 1.2  1993/01/15  23:04:26  wcp
 * Removed some garbage from comments.
 *
 * Revision 1.1  1993/01/06  17:59:05  wcp
 * Initial revision
 *
 */

#ifndef _common_h_INCLUDED
#define _common_h_INCLUDED

#include "config.h"
#undef FALSE
#undef TRUE
typedef enum { FALSE, OFF = FALSE, TRUE, ON = TRUE } bool;
typedef enum { LOW, HIGH, FINE = HIGH } Resolution;
typedef enum { NoIntrSheet, English, Deutsche, Italiano, Francais } IntrSheet;

#define SUCCEEDED	TRUE
#define FAILED		FALSE
#define DLE	'\020'
#define ETX	'\003'
#define DC1	'\021'
#define DC3	'\023'
#define XON	DC1
#define XOFF	DC3


#define ALLOW_FILE		"allow"
#define DENY_FILE		"deny"
#define CONFIG_FILE		"config"
#define PERSONAL_CONFIG_FILE	".faxem/config"
#define HIGH_RES_FONT		"hires.font"
#define LOW_RES_FONT		"lores.font"
#define ALIAS_FILE		"alias"
#define LOG_FILE		"log"
#define PERSONAL_ALIAS_FILE	".faxem/alias"

#undef min
#undef max
#ifdef __cplusplus
inline int min(int a, int b) { return (a < b) ? a : b; }
inline int max(int a, int b) { return (a < b) ? b : a; }
inline unsigned min(unsigned a, unsigned b) { return (a < b) ? a : b; }
inline unsigned max(unsigned a, unsigned b) { return (a < b) ? b : a; }
inline long min(long a, long b) { return (a < b) ? a : b; }
inline long max(long a, long b) { return (a < b) ? b : a; }
inline unsigned long min(unsigned long a, unsigned long b)
{
  return (a < b) ? a : b;
}
inline unsigned long max(unsigned long a, unsigned long b)
{
  return (a < b) ? b : a;
}

#else	/* __cplusplus */
#define min(a,b)	(((a) < (b)) ? (a) : (b))
#define max(a,b)	(((a) < (b)) ? (b) : (a))
#endif	/* __cplusplus */

#define ERROR	(-1)
#define dprint(l,c)	if (verbosity > (l)) fprintf c ;

/* The followings are in common.c */
extern const char *basename(const char *);
extern const char *vgets(unsigned);
extern int strcomp(const char*, const char *);
extern char *strlower(char *);
extern char *strupper(char *);
extern char *siteName(void);

extern bool lockLine(const char *, int);
extern bool isLocked(const char *);
extern bool unlockLine(const char *);
extern char *makeTemp(const char *);
extern bool glob(const char *, const char *);
#endif	/* _common_h_INCLUDED */
