/*
 * $Id: common.c,v 1.1 1993/01/06 17:58:33 wcp Exp $
 *
 * Copyright (C) 1992	Walter Pelissero
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Log: common.c,v $
 * Revision 1.1  1993/01/06  17:58:33  wcp
 * Initial revision
 *
 */

#include <ctype.h>
#include <string.h>
#include <stdio.h>
#include <sys/utsname.h>

static char RcsId[] = "$Id: common.c,v 1.1 1993/01/06 17:58:33 wcp Exp $";


/* vgets - Format one character in "always printable" format (like cat -v)
 */
const char *vgets(unsigned char c)
{
  static char buffer[10];
  char *pnt;
  
  pnt = buffer;
  if (iscntrl(c) || !isprint(c))
    {
      if (!isascii(c))
	{			/* Top bit is set */
	  *pnt++ = 'M';
	  *pnt++ = '-';
	  c = toascii(c);
	}
      if (iscntrl(c))
	{			/* Not printable */
	  *pnt++ = '^';
	  c = c < ' ' ? (c + '@') : '?';
	}
    }
  *pnt++ = c;
  *pnt = '\0';
  return(buffer);
}

int strcomp(const char *s1, const char *s2)
{
  for (; *s1 && *s2; ++s1, ++s2)
    {
      if (isalpha(*s1) && isalpha(*s2))
	{
	  int c;

	  if ((c = tolower(*s1) -tolower(*s2)))
	    return c;
	}
      else
	{
	  if (*s1 != *s2)
	    return *s1 - *s2;
	}
    }
  return *s1 - *s2;
}

const char *basename(const char *n)
{
  const char *name;

  if ((name = strrchr(n, '/')) == NULL)
    name = n;
  else
    ++name;
  return name;
}

char *strlower(char *s)
{
  char *p = s;

  for (; *s; ++s)
    *s = tolower(*s);
  return p;
}

char *strupper(char *s)
{
  char *p = s;

  for (; *s; ++s)
    *s = toupper(*s);
  return p;
}

char *siteName()
{
  struct utsname un;
  
  if (uname(&un) >= 0 && un.nodename[0] != '\0')
    return strdup(un.nodename);
  else
    {
      /* trying to get site name from the uuname -l command */
      FILE *fd = popen("uuname -l", "r");

      if (fd != (FILE *)0)
	{
	  char site[256];

	  site[0] = '\0';
	  if (fgets(site, sizeof(site), fd))
	    site[strlen(site) - 1] = '\0';	/* chop '\n' */
	  pclose(fd);
	  return strdup(site);
	}
    }
  return 0;
}
