/*
 * Copyright 1994, Free Software Association of Germany
 * All rights reserved.
 *
 */

#ifndef	_SHADOW_H
#define	_SHADOW_H

#include <features.h>

__BEGIN_DECLS

typedef	long	sptime;

struct	spwd {
	char	*sp_namp;	/* login name */
	char	*sp_pwdp;	/* encrypted password */
	sptime	sp_lstchg;	/* date of last change */
	sptime	sp_min;		/* minimum number of days between changes */
	sptime	sp_max;		/* maximum number of days between changes */
	sptime	sp_warn;	/* number of days of warning before password
						   expires */
	sptime	sp_inact;	/* number of days after password expires
						   until the account becomes unusable. */
	sptime	sp_expire;	/* days since 1/1/70 until account expires */
	unsigned long	sp_flag; /* reserved for future use */
};

/*
 * Shadow password security file functions.
 */

extern struct	spwd	*getspnam __P((char *__nam));
extern struct	spwd	*getspent __P((void));
extern struct	spwd	*sgetspent __P((char *__s));
extern struct	spwd	*fgetspent __P((FILE *__fp));
extern void	endspent __P((void));
extern void	setspent __P((void));

#define  SHADOW "/etc/shadow"

__END_DECLS
#endif
