
/* Copyright (C) 1991, 1992, 1993  Free Software Association of Germany

   This program is free software; you can redistribute it and/or modify
   it under the terms of the DFSL or the GNU General Public License as 
   published by the Free Software Association of Germany or the
   Free Software Foundation.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   DFSL or the GNU General Public License for more details.

   You should have received a copy of the DFSL or the GNU General 
   Public License along with this program; if not, write to the 
   Free Software Association, c/o Michaela Merz, Heimatring 19,
   60596  Frankfurt/Main, Germany. Or write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <stdio.h>
#include <fshadow.h>

int spos = -1;

/* #define DEBUG; */

#define strtok shtok  

char *shtok(char *,char *);

struct spwd *getshadowentry (int);


void setspent(void)
{
	if (spos < 0)	{
		getshadowentry(2);
		return;
		}
}


void endspent(void)
{
	if (spos >= 0)	{
		getshadowentry(0);
		return;
		}
}

struct spwd *getspent(void)
{
	return (getshadowentry(1));
} 

struct spwd *getspnam(char *s)
{
	static struct spwd *spw;

	while (1)	{
		spw = (struct spwd *)getshadowentry(1);
		if (spw == (struct spwd *)NULL)
			break;
		if (!strcmp(spw->sp_namp,s))
			return (spw);
		}
	return (NULL);
} 

struct spwd *getshadowentry (int mod)
{
	static char *tp;
	static FILE *sfp; 
	static struct spwd  shad;
	int a;
	char *t;

	if (mod == 0)	{                /* endspent */
		if (sfp != NULL)	{
			free (tp);
			free (shad.sp_namp);
			free (shad.sp_pwdp);
			fclose(sfp);
			sfp = (FILE *)NULL;
			}
		spos = -1;
		return ((struct spwd *)NULL);
		}	

	if (spos < 0)	{	
		sfp = fopen(SHADOW,"r");
		if (sfp == NULL)
			return ((struct spwd *)NULL);
		tp = (char *)malloc(500);
		spos = 0;
		bzero ((char *)&shad,sizeof(shad));
		if (mod == 2)		/* setspent() */
			return ((struct spwd *)NULL);
		}

	if (fgets(tp,499,sfp) == NULL)	
		return ((struct spwd *)NULL);
	
	for (a = 0; a < 9; a++)	{
		if (a == 0)
			t = (char *)strtok(tp,":");
		else
			t = (char *)strtok(NULL,":");

		if (t == NULL)
			t = "\0";
			
#ifdef DEBUG
		printf("field %d: <%s>\n",a,t);
#endif
 		switch(a)	{
			case 0:
				shad.sp_namp = (char *)realloc(shad.sp_namp,strlen(t)+1);
				strcpy(shad.sp_namp,t);
				break;
			case 1:
				shad.sp_pwdp = (char *)realloc(shad.sp_pwdp,strlen(t)+1);
	       			strcpy(shad.sp_pwdp,t);
       				break;
			case 2:
				shad.sp_lstchg = (sptime) atoi(t); break;
			case 3:
				shad.sp_min = (sptime) atoi(t); break;
			case 4:
				shad.sp_max = (sptime) atoi(t); break;
			case 5:
				shad.sp_warn = (sptime) atoi(t); break;
			case 6:
				shad.sp_inact  = (sptime) atoi(t); break;
			case 7:
				shad.sp_expire  = (sptime) atoi(t); break;
			case 8:
				shad.sp_flag  = (unsigned)atoi(t); break;
			}
		}
	return (&shad);
}


struct	spwd *fgetspent(FILE *fp)
{
	char tmp[2048];

	if (fgets(tmp,2047,fp) == NULL)
		return (NULL);

	return(sgetspent(tmp));
} 


struct spwd *sgetspent(char *s)
{
	int a;
	char *tp,*t;
	static struct spwd *__shad;


	if (s[strlen(s)-1] == 10)
		s[strlen(s)-1] = 0;


	if (__shad == NULL)	{
		__shad = (struct spwd *)malloc(sizeof(struct spwd));
		__shad->sp_namp = NULL; 
		__shad->sp_pwdp  = NULL;
		}

	tp = (char *)malloc (strlen(s)+1);
	strcpy(tp,s);

	for (a = 0; a < 9; a++)	{
		if (a == 0)
			t = (char *)strtok(tp,":");
		else
			t = (char *)strtok(NULL,":");

		if (t == NULL)
			t = "\0";

#ifdef DEBUG
		printf("Field %d: <%s>\n",a,t);
#endif
 		switch(a)	{

			case 0:
				__shad->sp_namp = (char *)realloc(__shad->sp_namp,strlen(t)+1);
				strcpy(__shad->sp_namp,t);
				break;
			case 1:
				__shad->sp_pwdp = (char *)realloc(__shad->sp_pwdp,strlen(t)+1);
				strcpy(__shad->sp_pwdp,t);
       			break;
			case 2:
				__shad->sp_lstchg = (sptime) atoi(t); break;
			case 3:
				__shad->sp_min = (sptime) atoi(t); break;
			case 4:
				__shad->sp_max = (sptime) atoi(t); break;
			case 5:
				__shad->sp_warn = (sptime) atoi(t); break;
			case 6:
				__shad->sp_inact  = (sptime) atoi(t); break;
			case 7:
				__shad->sp_expire  = (sptime) atoi(t); break;
			case 8:
				__shad->sp_flag  = (unsigned)atoi(t); break;
			}
		}
	free(tp);
	return (__shad);
}

char *shtok(char *ss,char *sy)
{
	static int a;
	int b,c;
	static char *tst;
	static char *s;
	
	b = 0;
 	
	if (ss != NULL)	{
		a = 0;
		b = 1;
		tst = (char *)realloc(tst,strlen(ss)+1);
		s = (char *)realloc(s,strlen(ss)+1);
		strcpy(s,ss);
		}

	c = 0;

	for (;;)	{

		if (a >= strlen(s))
			return (NULL);

		if (s[a] == ':')	{
			if (b == 1)	{
				tst[c] = 0;
				return (tst);
				}
				
			strcpy(tst,&s[a+1]);
			a++;
			
			for (b = 0; b < strlen(tst);b++)	{
				if (tst[b] == ':')	{
					tst[b] = 0;
					break;
					}
				}

			return (tst);
			}

		if (b == 1)
			tst[c++] = s[a];

		a++;
		}
}
	
