/***************************************************************************/
/** Project Andromeda                                                     **/
/** ~~~~~~~~~~~~~~~~~                                                     **/
/** graphdrv.h - Header file for graphdrv.c                               **/
/**              Portable implementation of graphic, mouse and keyboard   **/
/**                                                                       **/
/** V1.00  1/31/1997  Gerald Friedland  Initial version                   **/
/** V1.01  2/16/1997  Gerald Friedland  Fixed C++ Bug                     **/
/** V1.02  5/08/1997  Gerald Friedland  Made official release             **/
/**                                                                       **/
/***************************************************************************/
/*         To be distributed following GNU GPL Version 2.0 or later        */
/***************************************************************************/

#ifndef __GRAPHDRV_H
#define __GRAPHDRV_H

#define graphdrv_version 1.01

#ifdef  __cplusplus
extern "C" {
#endif

extern char *graph_pointer; /* Points to linear addressed video memory, just write in here */
extern unsigned char use_mouse; /* Becomes 0 if videoinit320 detects no mouse */

/* Graphic functions */
extern void videoinit320 (void);  /* Before ANY call to any other function, call this ! */
extern void videodone(void);      /* Call this on exit ! (Especially important on Linux systems !) */

extern int getpixel(int x,int y); /* Get pixel color at position x,y */
extern void putpixel(int x, int y, int color); /* Put pixel with color at x,y */

extern void waitretrace(void);   /* Wait until video retrace */
extern void setrgbpal (unsigned char c, unsigned char r, unsigned char g, unsigned char b); 
/* Set red, green and blue value of color */ 

/* Keyboard functions */
extern unsigned char getkey(void); /* Get current status of keyboard */

/* Mouse functions */
extern int getmousex(void); /* Get mouse's x-position */
extern int getmousey(void); /* Get mouse's y-position */
extern int getmousebuttons(void); /* Get status of buttons: 0=all released, 1=left, 2=right, 4=middle */

extern void showmousecursor(void); /* Show mouse cursor (DOS ONLY !) */
extern void hidemousecursor(void);  /* Hide mouse cursor (DOS ONLY !) */

#ifdef  __cplusplus
}
#endif

#endif
