/***************************************************************************/
/** Project Andromeda                                                     **/
/** ~~~~~~~~~~~~~~~~~                                                     **/
/** graphdrv.c - portable implementation of graphic, mouse and            **/
/**              keyboard routines to be used for game coding             **/
/**                                                                       **/
/** V1.00  1/31/1997  Gerald Friedland                                    **/
/** V1.01  2/16/1997  Gerald Friedland  Fixed non portable ptr conversion **/
/** V1.02  5/08/1997  Gerald Friedland  Made official release             **/
/**                                                                       **/
/***************************************************************************/
/*           To be distributed following GNU GPL 2.0 or later              */
/***************************************************************************/

#ifndef __linux__ 
   #ifndef __WATCOMC__
   	#error Need Watcom C/C++ 10.x or Linux GNU C++ with svgalib
   #endif
#endif

#ifdef __linux__
   #include <fcntl.h>
   #include "vga.h"
   #include "vgakeyboard.h"
   #include "vgamouse.h"
   #define use_vgalib
#endif

#ifdef __DOS__
   #define use_watcom
   #include <i86.h>
   #include <graph.h>
   #include <conio.h>
#endif

#include <stdio.h>
#include "graphdrv.h"

char *graph_pointer; /* Points to linear addressed video memory, just write in here */
unsigned char use_mouse; /* Becomes 0 if videoinit320 detects no mouse */

int getpixel(int x,int y)
{
 #ifdef use_vgalib
 return(vga_getpixel(x,y));
 #endif
 #ifdef use_watcom
 return(_getpixel(x,y));
 #endif
}
 
unsigned char getkey(void)
{
   unsigned char i;
   #ifdef use_vgalib
   keyboard_update(); 
   for (i=1;i<112;i++) {
      if (keyboard_keypressed(i)!=0) return(i);    
   } 
   #endif
   #ifdef use_watcom
   return(inp(0x60));
   #endif
}

int getmousex(void)
{
   #ifdef use_vgalib
   mouse_update(); 
   return(mouse_getx());
   #endif
   #ifdef use_watcom
   union REGS inregs,outregs;
   inregs.w.ax = 0x03;
   int386(0x33, &inregs, &outregs);
   return(outregs.w.cx);
   #endif
}

int getmousey(void)
{
   #ifdef use_vgalib
   mouse_update(); 
   return(mouse_gety());
   #endif
   #ifdef use_watcom
   union REGS inregs,outregs;
   inregs.w.ax = 0x03;
   int386(0x33, &inregs, &outregs);
   return(outregs.w.dx);
   #endif
}

int getmousebuttons(void)
{
   #ifdef use_vgalib
   unsigned char i;
   mouse_update(); 
   i=mouse_getbutton();
   if (i>1) {
      if (i & MOUSE_LEFTBUTTON) return(1);
      if (i & MOUSE_RIGHTBUTTON) return(2);
      if (i & MOUSE_MIDDLEBUTTON) return(4);
   }
   else return(0);
   #endif
   #ifdef use_watcom
   union REGS inregs,outregs;
   inregs.w.ax = 0x03;
   int386(0x33, &inregs, &outregs);
   return(outregs.w.bx);
   #endif
}
   
void putpixel(int x, int y, int color)
{
   #ifdef use_vgalib
   vga_setcolor(color);
   vga_drawpixel(x,y);
   #endif
   #ifdef use_watcom
   _setcolor(color);
   _setpixel(x,y);   
   #endif
}
  
void showmousecursor(void)
{
   #ifdef use_vgalib
   #warning showmousecursor() is not implemented.
   #endif
   #ifdef use_watcom
   union REGS inregs,outregs;
   inregs.w.ax = 0x1;
   int386 (0x33, &inregs, &outregs);
   #endif
}

void hidemousecursor(void)
{  
    #ifdef use_vgalib
    #warning hidemousecursor() is not implemented.
    #endif   
    #ifdef use_watcom
    union REGS inregs,outregs;
    inregs.w.ax = 0x2;
    int386 (0x33, &inregs, &outregs);
    #endif
}

void setrgbpal (unsigned char c, unsigned char r, unsigned char g, unsigned char b)
{
   #ifdef use_vgalib
   vga_setpalette(c,r,g,b); 
   #endif
   #ifdef use_watcom
   outp(0x3c8,c);
   outp(0x3c9,r);
   outp(0x3c9,g);
   outp(0x3c9,b);
   #endif
}

void videoinit320 (void)
{
   #ifdef use_vgalib
   int testdesc=-1;
   if ((testdesc=open("/dev/console", O_RDONLY))<0) {
      fprintf(stderr,"graphdrv.c: Hint:\n");
      fprintf(stderr,"graphdrv.c: If the console cannot be opened then\n");
      fprintf(stderr,"graphdrv.c: ask your system administrator to:\n");
      fprintf(stderr,"graphdrv.c:	chown root <executable>\n");
      fprintf(stderr,"graphdrv.c:	chmod a+s <executable>\n");
      fprintf(stderr,"graphdrv.c: With <executable> being this file.\n\n");    
   }
   vga_setmousesupport(1);
   use_mouse=1;
   if (vga_setmode(G320x200x256)==-1) {
      fprintf(stderr,"graphdrv.c: ERROR: VGA card required. \n");
      exit(1);
   }
   graph_pointer=vga_getgraphmem();
   if (keyboard_init()) {
      fprintf(stderr,"graphdrv.c: ERROR: Could not initialize keyboard.\n");
      exit(1);
   }
   keyboard_translatekeys(TRANSLATE_CURSORKEYS | TRANSLATE_KEYPADENTER | TRANSLATE_DIAGONAL);   
   #endif
   #ifdef use_watcom
   union REGS inregs,outregs;
   if (_setvideomode(_MRES256COLOR)==0) {
	fprintf(stderr,"graphdrv.c: ERROR: VGA card required ! \n");
	exit(1);
   }
   graph_pointer=(char *) 0xa0000; /* Set pointer to 0xa0000 fixed */
   inregs.w.ax = 0; 	  /* Detect mouse, use_mouse contains information on installation  */	
   int386 (0x33, &inregs, &outregs);
   if (!(use_mouse = (outregs.w.ax == -1))) fprintf (stderr,"graphdrv.c: No mouse detected !\n");
   #endif
}

void videodone(void)
{
   #ifdef use_vgalib
   keyboard_close();
   vga_setmode(TEXT);
   #endif
   #ifdef use_watcom
   _setvideomode(_DEFAULTMODE);
   #endif
}

#ifdef use_watcom
void __watcomc__dos_waitretrace(void);

#pragma aux __watcomc__dos_waitretrace = \
    "mov   dx,3DAh" \
    "@@1:" \
    "in    al,dx" \
    "test  al,8" \
    "jnz   @@1"  \
    "@@2:" \
    "in    al,dx" \
    "test  al,8" \
    "jz    @@2" \
    modify;

#endif

void waitretrace(void)
{
   #ifdef use_vgalib
   vga_waitretrace();
   #endif
   #ifdef use_watcom
   __watcomc__dos_waitretrace();
   #endif
}
