/*
  	#[ includes :

	File contains a new event handler.
	Is based on a free interpretation of evnt_multi, so that we should
	be able to construct a wpollevent and that the occasional problems
	with the timer don't occur.

	Strategy:	Before the evnt_multi call in wpollevent we put a
				message in the pipe. If the message arrives there was
				no event.

*/

#include "window.h"

static struct no_event{
	int	code;
	long number;
} s_no_event;

int isnoevent;

#define DIST_CLICK  5
#define CLICK_TICKS 500L

static int  mupwaiting[3];
static msec prev_tick[3];
int  prev_state[3];
static int	what_button;
static int  prev_h;
static int  prev_v;
static int  nr_clicks[3];

static EVENT    levent;
static EVENT	tevent;		/* temporary storage for multiple events */
static WINDOW *lactive;

static int shape;
static int oldshape;

static void do_timer (EVENT *);
static bool find_update (EVENT *);
static long set_timer (EVENT *);
static void do_keybd (EVENT *, int, int);
static void do_button (EVENT *, int *, int *, int *);
static void do_messag (EVENT *, int *);
static void do_redraw (int *);
static void do_topped (EVENT *, int *);
static void do_closed (EVENT *, int *);
static void do_size (EVENT *, int *);
static void int_getevent(EVENT *ep,int pollflag);

static WINDOW *timer_win;

extern bool (*own_keybd)(EVENT *, int, int, int, int);

int ClickSpeed;

/*
  	#] includes :
  	#[ event:			The event library.
 		#[ w_strt_event :		void w_strt_event()
*/

void
w_strt_event()
{
	lactive = (WINDOW *) NULL;
	levent.type = WE_NULL;
	mupwaiting[1] = mupwaiting[2] = FALSE;
	prev_tick[1] = prev_tick[2] = 0;
	prev_state[1] = 0;
	prev_state[2] = 0;
	prev_h = 10;
	prev_v = 10;
	nr_clicks[1] = nr_clicks[2] = 0;
	shape = ARROW;
	oldshape = THIN_CROSS;
	s_no_event.code = -1;
	s_no_event.number = 0;
	isnoevent = 0;
	tevent.type = WE_NULL;
	ClickSpeed = evnt_dclick(0,0);
	evnt_dclick(4,1);			/* High Speed */
}

/*
 		#] w_strt_event :
 		#[ wungetevent :		void wungetevent(ep)
*/

void
wungetevent(ep)
EVENT *ep;
{
	levent = *ep;
}

/*
 		#] wungetevent :
 		#[ wpollevent :
*/

void
wpollevent(ep)
EVENT *ep;
{
	int_getevent(ep,1);
}

/*
 		#] wpollevent :
 		#[ wgetevent :			void wgetevent(ep)
*/

void
wgetevent(ep)
EVENT *ep;
{
	int_getevent(ep,0);
}

/*
 		#] wgetevent :
 		#[ int_getevent :		void int_getevent(ep,pollflag)
*/

void
int_getevent(ep,pollflag)
EVENT *ep;
int pollflag;
{
	int	which = (MU_TIMER | MU_KEYBD | MU_BUTTON | MU_MESAG | MU_M2);
								/* Which events are relevant          */
	int	num_clicks = 1;			/* How many clicks are you waiting for*/
	int	button_state;			/* What button state are you waiting  */
	int	msg_buf[8];				/* Buffer for message returned        */
	unsigned int lowtime;		/* Low word for timer                 */
	int	hightime;				/* High word for timer                */
	int	m_x, m_y, m_b, m_k;		/* integers for Mouse                 */
								/* Mouse postion when event occured   */
	int	key_pressed;			/* The key pressed                    */
	int	nr_times;				/* Nr of times mouse entered state    */
	int	clickinout = 1;
	int	wininout = 0;
	int	x_clickrect,y_clickrect,w_clickrect,h_clickrect;
	int	x_winrect,y_winrect,w_winrect,h_winrect;
	int	dummy = 0;
	int	rc;
	long timervalue, x;
	int first = 1;

	int reduced_which;

	if ( tevent.type != WE_NULL ) {
		*ep = tevent;
		tevent.type = WE_NULL;
		goto WithEvent;
	}

	menuupdate();

	if ( levent.type != WE_NULL ) {
		*ep = levent;
		levent.type = WE_NULL;
		return;
	}

	what_button = 1;		/* Start with left button */

tryagain:

	if ( mupwaiting[what_button] ) {
		ep->type = WE_MOUSE_UP;
		ep->window = active;
		ep->u.where.button = what_button;
		ep->u.where.h = prev_h;
		ep->u.where.v = prev_v;
		ep->u.where.clicks = num_clicks;
		mupwaiting[what_button] = mousedown[what_button] = FALSE;
		prev_tick[what_button] = mclock();
		return;
	}

	if ( first ) {
		if ( lactive != active && active != NULL ) {
			ep->type = WE_ACTIVATE;
			ep->window = active;
			lactive = active;
			wind_set (active->handle, WF_TOP, dummy, dummy, dummy, dummy);
			return;
		}
		else
			lactive = active;
	}

	ep->type = WE_NULL;

	do {
		timervalue = set_timer(ep);

		if ( ep->type == WE_TIMER ) return;

		timervalue = 1;

		hightime = timervalue >> 16;
		lowtime = timervalue;

		if ( mousedown[what_button] ) {	/* waiting for button up */
			which |= MU_M1;
			DOCTOSCR (active, prev_h, prev_v, x_clickrect,
								y_clickrect);
			x_clickrect -= 1;
			y_clickrect -= 1;
			w_clickrect = 3;
			h_clickrect = 3;
		}
		else which &= ~MU_M1;

		if ( active != NULL ) {
			which |= MU_M2;

			x_winrect = active->h;
			y_winrect = active->v;
			w_winrect = active->width;
			h_winrect = active->height;

			wininout = shape == THIN_CROSS;
		}
		else
			which &= ~MU_M2;

		if ( shape != oldshape ) {
			oldshape = shape;
			graf_mouse (shape, (MFORM *)0);
		}

		if (mouseoff) {
			mouseoff = FALSE;
			graf_mouse (M_ON, (MFORM *)0);
		}

		button_state = what_button - prev_state[what_button];

		rc = evnt_multi (
				which,
 				num_clicks,
				what_button,
				button_state,
				clickinout,
				x_clickrect,y_clickrect,w_clickrect,h_clickrect,
				wininout,
				x_winrect,y_winrect,w_winrect,h_winrect,
				msg_buf,
				lowtime,
				hightime,
				&m_x, &m_y, &m_b, &m_k,
				&key_pressed,
				&nr_times);
/*
		Main problem: there may be more than one event type.
*/
		tevent = *ep;
/*
		Did a timer go off?

		if ( ( rc & MU_TIMER ) != 0 ) {
			tevent.type &= ~MU_TIMER;
			do_timer (ep);
			if (ep->type != WE_NULL)
				break;

			Did the polling timer go off?
*/
		if ( rc == MU_TIMER ) {
			what_button += 1;		/* Left, right */
			if ( what_button >= 3 ) {
				ep->type = WE_NULL;
				if ( pollflag ) return;				/* No event */
				what_button = 1;
			}
			first = 0;
			goto tryagain;
		}
		else rc &= ~MU_TIMER;
/*
		}
*/
		tevent.type &= ~MU_TIMER;
WithEvent:
		if ( ( rc & MU_KEYBD ) != 0 ) {
			tevent.type &= ~MU_KEYBD;
			if ( own_keybd ) {
				int ascii_part, number_part;
				ascii_part = key_pressed & 0xFF;
				number_part = ( key_pressed >> 8 ) & 0xFF;
				if ( (*own_keybd)(ep,ascii_part,m_k,number_part,0) ) break;
			}
			do_keybd (ep, key_pressed, m_k);
			if ( ep->type != WE_NULL ) break;
		}

		if ( ( rc & MU_M1 ) != 0 || ( rc & MU_BUTTON ) != 0 ) {
			tevent.type &= ~(MU_M1|MU_BUTTON);
			do_button (ep, &m_x, &m_y, &m_b);
			if ( ep->type != WE_NULL ) break;
		}

		if ( ( rc & MU_M2 ) != 0 ) {
			tevent.type &= ~MU_M2;
			if ( !mousedown[what_button] ) {
				if (shape == ARROW) {
					oldshape = shape;
					shape = THIN_CROSS;
				}
				else {
					oldshape = shape;
					shape = ARROW;
				}
			}
		}

		if ( ( rc & MU_MESAG ) != 0 ) {
			tevent.type &= ~MU_MESAG;
			do_messag (ep, msg_buf);
		}

	} while (ep->type == WE_NULL);
}

/*
 		#] int_getevent :
 		#[ wsetkeyhandler :		void wsetkeyhandler(own_k)
*/

void
wsetkeyhandler(own_k)
bool (*own_k)(EVENT *, int, int, int, int);
{
	own_keybd = own_k;
}

/*
 		#] wsetkeyhandler :
 		#[ do_timer :			static void do_timer(ep)
*/

static void
do_timer(ep)
EVENT *ep;
{
	if ( find_update(ep) ) return;

	ep->type = WE_TIMER;
	ep->window = timer_win;
	wsettimer (timer_win, 0);
}

/*
 		#] do_timer :
 		#[ find_update :		static bool find_update(ep)
*/

static bool
find_update(ep)
EVENT *ep;
{
	int i;
	bool rc = FALSE;
	WINDOW *act;

	act = active;
	if ( act != NULL && act->needupdate ) {
		rc = TRUE;
		if ( act->drawproc == NULL ) goto Done;
		else wupdate(act);
	}
	for (i = 0; i < nrwin; i++) {
		act = winlist[i];
		if ( act != active && act->needupdate ) {
			rc = TRUE;
			if ( act->drawproc == NULL ) {
Done:
				ep->type = WE_DRAW;
				ep->window = act;
				wgetchange (act, &ep->u.area.left,
							&ep->u.area.top,
							&ep->u.area.right,
							&ep->u.area.bottom);
				wupdate(ep->window);
				break;
			}
			else wupdate (act);
		}
	}
	return (rc);
}

/*
 		#] find_update :
 		#[ set_timer :			static void set_timer(ep, phightime, plowtime)
*/

static long
set_timer(ep)
EVENT *ep;
{
	msec currtime;
	int i;
	bool pend_updates = FALSE;
	long retval = 0;

	timer_win = NULL;

	currtime = mclock();

	for (i = 0; i < nrwin; i++) {
		WINDOW *cand = winlist[i];
		msec t = cand->alarm;

		if (t > 0) {
			if ( timer_win == NULL || t < timer_win->alarm ) timer_win = cand;
		}

		if ( cand->needupdate ) pend_updates = TRUE;
	}

	if ( timer_win != NULL ) {
/*
		window with alarm set found
*/
		if ( timer_win->alarm <= currtime ) {
/*
			alarm should go of somewhere in the past.
			return a timer event from this window
*/
			ep->type = WE_TIMER;
			ep->window = timer_win;
			wsettimer(timer_win, 0);
		}
		else if ( pend_updates == TRUE ) {
/*
			There are pendings updates. Set the timer on 1 msec
			to check that there aren't any events waiting.
*/
			retval = -1;
		}
		else {
/*
			Set the timer to the alarm time.
*/
			retval = timer_win->alarm - currtime;
		}
	}
	else if ( pend_updates == TRUE ) {
/*
		There are pendings updates. Set the timer on 1 msec
		to check that there aren't any events waiting.
*/
		retval = -1;
	}
	else {
/*
		No window found with an alarm set
*/
		retval = -2;
	}
	return(retval);
}

/*
 		#] set_timer :
 		#[ do_keybd :			static void do_keybd(ep, key)
*/

static void
do_keybd(ep, key, status)
EVENT *ep;
int key;
int status;
{
/*
	int	status;
	vq_key_s(vdi_handle, &status);
*/
	if ( ( status & 0x08 ) != 0			/* alternate key is pressed */
		&& ( status & 0x7 ) == 0 ) {	/* and not l-shift, r-shift or ctrl */
		checksc (ep, key);
		return;
	}

	if ( (key & 0xFF) == 0 ) {
/*
		'Special' key: If last  byte is nul then check extract
		from the first byte the key number.
*/
		switch ( key >> 8 ) {
			case 0x47 :					/* Clr Home */
				ep->u.command = WC_CLEAR;
				break;
			case 0x48 :					/* Cursor Up */
				ep->u.command = WC_UP;
				break;
			case 0x4B :					/* Cursor Left */
				ep->u.command = WC_LEFT;
				break;
			case 0x4D :					/* Cursor Right */
				ep->u.command = WC_RIGHT;
				break;
			case 0x50 :					/* Cursor Down */
				ep->u.command = WC_DOWN;
				break;
			case 0x52 :					/* Insert */
				ep->u.command = WC_INS;
				break;
			case 0x53 :					/* Delete */
				ep->u.command = WC_DEL;
				break;
			case 0x61 :					/* Undo */
				ep->u.command = WC_CANCEL;
				break;
			default :
				return;
		}

		ep->type = WE_COMMAND;
		ep->window = active;
		return;
	}

	ep->type = WE_COMMAND;
	ep->window = active;

	switch ( key & 0xFF ) {
		case 0x03 :
			ep->u.command = WC_CANCEL;
			break;
		case 0x08 :
			ep->u.command = WC_BACKSPACE;
			break;
		case 0x09 :
			ep->u.command = WC_TAB;
			break;
		case 0x0A :
		case 0x0D :
			ep->u.command = WC_RETURN;
			break;
		default :
			ep->type = WE_CHAR;
			ep->window = active;
			ep->u.character = key & 0xFF;
			break;
	}
}

/*
 		#] do_keybd :
 		#[ do_button :			static void do_button(ep,x,y,b)
*/

static void
do_button(ep,x,y,b)
EVENT *ep;
int *x, *y, *b;
{
	WINDOW *win = active;
	msec tick;
	int	h;
	int	v;
	int	dh;
	int	dv;

	if ( win == NULL ||
	    ( ( *x < win->h || *x > win->h + win->width ||
	        *y < win->v || *y > win->v + win->height ) &&
	     !mousedown[what_button] ) )
		return;

	tick = mclock();
	while ( tick < prev_tick[what_button] ) prev_tick[what_button] -= 10*0x8000L;

	SCRTODOC (win, *x, *y, h, v);

	dh = h - prev_h;
	dv = v - prev_v;

	if ( dh*dh+dv*dv > DIST_CLICK*DIST_CLICK ) nr_clicks[what_button] = 0;

	if ( prev_state[what_button] == what_button ) {
		if ( !(*b & what_button) ) {				/*	Mouse up event */
			ep->type = WE_MOUSE_UP;
			ep->u.where.button = what_button;	/*	Till now only the
												leftmost button is detected */
			mousedown[what_button] = FALSE;
		}
		else {
			if ( nr_clicks[what_button] > 0 || dh*dh+dv*dv == 0 ) return;
			else {
				if (*x < win->h ||
				    *x > win->h + win->width ||
				    *y < win->v ||
				    *y > win->v + win->height)
					autoscroll (win, *x, *y);
	
				ep->type = WE_MOUSE_MOVE;
				ep->u.where.button = what_button;
			}
		}
	}
	else {
		if ( !(*b & what_button) ) mupwaiting[what_button] = TRUE;

		if (tick - prev_tick[what_button] <= CLICK_TICKS) (nr_clicks[what_button])++;
		else                                 nr_clicks[what_button] = 1;

		ep->type = WE_MOUSE_DOWN;
		ep->u.where.button = what_button;
		mousedown[what_button] = TRUE;
	}

	ep->window = win;
	ep->u.where.h = prev_h = h;
	ep->u.where.v = prev_v = v;
	ep->u.where.clicks = nr_clicks[what_button];

	prev_tick[what_button] = tick;
	prev_state[what_button] = *b & what_button;
}

/*
 		#] do_button :
 		#[ do_messag :			static void do_messag(ep, msg_buf)
*/

static void
do_messag(ep, msg_buf)
EVENT *ep;
int	*msg_buf;
{
	switch ( msg_buf[0] ) {
		case MN_SELECTED :
			do_menu(ep, msg_buf);
			break;
		case WM_REDRAW :
			do_redraw(msg_buf);
			break;
		case WM_TOPPED :
			do_topped(ep, msg_buf);
			break;
		case WM_CLOSED :
			do_closed(ep, msg_buf);
			break;
		case WM_FULLED :
		case WM_SIZED :
		case WM_MOVED :
			do_size(ep, msg_buf);
			break;
		case WM_ARROWED :
		case WM_HSLID :
		case WM_VSLID :
			do_scroll(msg_buf);
			break;
	}
}

/*
 		#] do_messag :
 		#[ do_redraw :			static void do_redraw(msg_buf)
*/

static void
do_redraw(msg_buf)
int *msg_buf;
{
	WINDOW *win;
	int changed[4];
	int work[4];

	win = getwin(msg_buf[3]);

	if ( win == NULL ) return;

	SCRTODOC(win, msg_buf[4], msg_buf[5], changed[0], changed[1]);

	changed[2] = changed[0] + msg_buf[6];
	changed[3] = changed[1] + msg_buf[7];

	wgetwinorigin (win, &work[0], &work[1]);
	wgetwinsize(win, &work[2], &work[3]);

	work[2] += work[0];
	work[3] += work[1];

	if ( !intersect (work, changed) ) return;

	wchange (win, changed[0], changed[1], changed[2], changed[3]);
}

/*
 		#] do_redraw :
 		#[ do_topped :			static void do_topped(ep, msg_buf)
*/

static void
do_topped(ep, msg_buf)
EVENT *ep;
int *msg_buf;
{
	WINDOW *win = getwin (msg_buf[3]);

	if ( win == NULL ) return;

	ep->type = WE_ACTIVATE;
	ep->window = win;
	wsetactive(win);
	lactive = active;
}

/*
 		#] do_topped :
 		#[ do_closed :			static void do_closed(ep, msg_buf)
*/

static void
do_closed(ep, msg_buf)
EVENT *ep;
int *msg_buf;
{
	WINDOW *win = getwin(msg_buf[3]);

	if ( win == NULL ) return;

	ep->type = WE_COMMAND;
	ep->window = win;
	ep->u.command = WC_CLOSE;
}

/*
 		#] do_closed :
 		#[ do_size :			static void do_size(ep, msg_buf)
*/

static void
do_size(ep, msg_buf)
EVENT *ep;
int *msg_buf;
{
	WINDOW *win = getwin (msg_buf[3]);
	int orgh = win->orgh;
	int orgv = win->orgv;
	int h;
	int v;
	int width;
	int height;
	int x;

	if ( win == NULL ) return;

	if ( msg_buf[0] == WM_FULLED ) {
		if ( win->fulled ) {
			wind_get(win->handle, WF_PREVXYWH, &h, &v, &width,&height);
			win->fulled = FALSE;
		}
		else {
			wind_get(win->handle, WF_FULLXYWH, &h, &v, &width,&height);
			win->fulled = TRUE;
		}
	}
	else {
		h			= msg_buf[4];
		v			= msg_buf[5];
		width		= msg_buf[6];
		height		= msg_buf[7];
		win->fulled = FALSE;
	}

	if ( !win->console ) {
		if ( ( x = h+w_l_border & 7 ) != 0 ) {
			h -= x;
			if ( x > 4 ) h += 8;
		}
		if ( ( x = ( height - w_t_border -w_b_border ) % chheight ) != 0 ) {
			height -= x;
		}
		if ( ( x = ( width - w_l_border -w_r_border ) % 8 ) != 0 ) {
			width -= x;
		}
	}

	if ( !wind_set (win->handle, WF_CURRXYWH, h, v, width, height) ) return;
	_setsize(win, h, v, width, height);

	if ( win->orgh + win->width > win->doc_width + 10 )
		orgh = win->doc_width - win->width + 10;

	if ( win->orgv + win->height > win->doc_height + wlineheight() )
		orgv = win->doc_height - win->height + wlineheight ();

	wsetorigin(win, orgh, orgv);
	setscrollbars (win);

	if ( msg_buf[0] != WM_MOVED ) {
		ep->type = WE_SIZE;
		ep->window = win;
	}
}

/*
 		#] do_size :
  	#] event:
*/
