
/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */
/*
 * swapgifcmap.c - well, i hate how Photoshop quantize the images. By
 *                 default the white color is the first, this program
 *                 swap the color map of GIF images.
 *
 * Author:      Raul Rivero
 *              Vicerrectorado de Estudiantes 
 *              University of Oviedo
 * Date:        Sat Aug 05 1995
 * Copyright (c) 1995, Raul Rivero
 *
 */

#include <lug.h>
#include <lugfnts.h>

extern int LUGverbose;
extern char *MY_NAME; 

main( argc, argv )
int argc;
char **argv;
{
  int i;
  bitmap_hdr in;

  MY_NAME = argv[0];

   /*
   * Get options ( some day I'll build a procedure ).
   */
  if ( argc > 1 ) {             /* else core on SGI */
    while ( argv[1][0] == '-' ) {
      for ( i = 1; argv[1][i]; i++ ) {
        switch ( argv[1][i] ) {
                case 'v':
                        LUGverbose++;
                        break;
                default :
                        fprintf( stderr, "Usage: %s [-v] <input_gif_image> [<output_gif_image>]\n",
                                 MY_NAME );
                        exit( 0 );
                        break;
        }
      }
      argv++;
      argc--;
    }
  }

  if ( argc < 3 ) {
    fprintf( stderr, "Usage: %s [-v] <input_image> [<output_gif_image>]\n",
             MY_NAME );
    exit( 0 );
  }

  /* Read the input file */
  read_gif_file( argv[1], &in );

  /* Swap the coor map */
  swap_cmap( &in );

  /* Write the file */
  if ( argc > 2 )
    write_gif_file( argv[2], &in );
  else write_gif( stdout, &in );

}
