/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */
/*
 * reborde.c - builds a border arround the input image. We use it to
 *             insert images in our WWW server (http://www3.uniovi.es/). 
 *
 * Author:      Raul Rivero
 *              Vice-Rectorado de Estudiantes y Extension Universitaria 
 *              University of Oviedo
 * Date:        Sat Jul 1 1995
 * Copyright (c) 1995, Raul Rivero
 *
 */

#include <lug.h>
#include <lugfnts.h>

main( argc, argv )
int argc;
char **argv;
{
  bitmap_hdr in, in2;


  if ( argc < 3 ) {
    fprintf( stderr, "Use: %s <input_image> <output_image>\n" );
    exit( 1 );
  }

  read_lug_file( argv[1], &in );

  if ( in.depth < 24 ) {
    to24( &in, &in2 );
    mete_reborde( &in2 );
    write_lug_file( argv[2], &in2 );
  }else{
    mete_reborde( &in );
    write_lug_file( argv[2], &in );
  }
}

mete_reborde( image )
bitmap_hdr *image;
{
  byte *rptr, *gptr, *bptr;
  register int i;

  /* Primera linea gris */
  rptr = image->r, gptr = image->g, bptr = image->b;
  for ( i = 0; i < image->xsize; i++ ) 
    *rptr++ = *gptr++ = *bptr++ = 189;
  /* Segunda linea (menos ultimo pixel) negro */
  for ( i = 0; i < image->xsize-1; i++ ) 
    *rptr++ = *gptr++ = *bptr++ = 0;
  /* Primera columna gris */
  rptr = image->r, gptr = image->g, bptr = image->b;
  for ( i = 0; i < image->ysize; i++ ) {
    *rptr++ = *gptr++ = *bptr++ = 189;
    if ( i != 0 )
      *rptr = *gptr = *bptr = 0;
    if ( i != image->ysize-1 ) {
      rptr += image->xsize-1;
      gptr += image->xsize-1;
      bptr += image->xsize-1;
    }
  }
  /* Penultima columna gris y ultima blanca */
  rptr = image->r + image->xsize-2,
  gptr = image->g + image->xsize-2,
  bptr = image->b + image->xsize-2;
  for ( i = 0; i < image->ysize; i++ ) {
    if ( i > 1 )
      *rptr++ = *gptr++ = *bptr++ = 189;
    else {
      rptr++; gptr++; bptr++;
    }
    if ( i != 0 )
      *rptr = *gptr = *bptr = 255;
    if ( i != image->ysize-1 ) {
      rptr += image->xsize-1;
      gptr += image->xsize-1;
      bptr += image->xsize-1;
    }
  }
  /* Antepenultima linea gris */
  rptr = image->r + image->xsize*(image->ysize-2),
  gptr = image->g + image->xsize*(image->ysize-2),
  bptr = image->b + image->xsize*(image->ysize-2);
  for ( i = 0; i < image->xsize; i++ ) 
    if ( i != image->xsize-1 )
      if ( i == 1 )
        *rptr++ = *gptr++ = *bptr++ = 0;
      else *rptr++ = *gptr++ = *bptr++ = 189;
  /* Ultima linea blanca */
  rptr++; gptr++; bptr++; 
  for ( i = 0; i < image->xsize-1; i++ )
      if ( i == 0 )
	*rptr++ = *gptr++ = *bptr++ = 189;
      else *rptr++ = *gptr++ = *bptr++ = 255;
}
