/*
 *  netlnk.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef NETLNK_DOT_H
#define NETLNK_DOT_H
#include "ObjProDSP/portable.h"
#include "ObjProArith/hrdarth.h"
#include "ObjProUsr/buffer.h"
#include "ObjProGen/errcode.h"



struct DfNodeInLink {
	int ElementSize;
	int32 BlockSize ;
	int32 Overlap ;
	int32 IncrementIn ;
	int32 Delay ;
	int BufferChannelIndex ;
	OutputBuffer * TheBuffer ;
	int Channel ;
	int DivisorShift ;
	int DivisorFactor ;
	int32 MinimumExecute ;
	int32 History ;

	// DfNodeInLink(){}
	void Init(int element_size,int32 block_size, int buf_inx,
		OutputBuffer *buf) ;
	int GetElementSize() { return ElementSize;}
	int GetBlockSize() { return BlockSize;}

	void UpdateRead(int32 size)
		{TheBuffer->UpdateRead(BufferChannelIndex,size);}
	const MachWord * GetReadPtr() const  
		{ return TheBuffer->GetReadPtr(BufferChannelIndex);}
	const MachWord * GetReadBase() const  
		{ return TheBuffer->GetBase();}
	const MachWord * GetReadEnd() const  
		{ return TheBuffer->GetEnd();}

	const UnsignedIntegerMachWord * GetBinReadPtr() const
		{ return TheBuffer->GetBinReadPtr(BufferChannelIndex);}
	const UnsignedIntegerMachWord * GetBinReadBase() const 
		{ return TheBuffer->GetBinBase();}
	const UnsignedIntegerMachWord * GetBinReadEnd() const 
		{ return TheBuffer->GetBinEnd();}

	int32 GetIncrementIn() const {return IncrementIn;}
	MachWord ReadWord() {return TheBuffer->ReadWord(BufferChannelIndex);}
	UnsignedIntegerMachWord ReadBinary()
		{return TheBuffer->ReadBinary(BufferChannelIndex);}

	int32 GetAvailableSpace() const
		{return TheBuffer->GetAvailableSpace();}
	int32 GetContiguousAvailableSpace() const
		{return TheBuffer->GetContiguousAvailableSpace();}

	int32 GetAvailableData() const
		{return TheBuffer->GetAvailableData(BufferChannelIndex);}
	int32 GetContiguousAvailableData() const 
		{return TheBuffer->GetContiguousAvailableData(
			BufferChannelIndex);}
	CxMachWord ReadCxWord()
		{return TheBuffer->ReadCxWord(BufferChannelIndex);}
	int32 GetDynamicCount(int seq_index) const;
	int GetNodeInputChannel() const {return Channel;}
	TargetNode * GetDriverNode() const ;
	ErrCode Reset();
};

struct DfNodeOutLink {
	int ElementSize;
	int32 BlockSize ;
	int32 IncrementOut ;
	OutputBuffer * TheBuffer ;
	int Channel ;
	int DivisorShift ;
	int DivisorFactor ;
	int32 MinimumExecute ;
	// DfNodeOutLink(){}
	void Init(int element_size,int32 block_size,OutputBuffer *buf) ;
	int GetElementSize() { return ElementSize;}
	int GetBlockSize() { return BlockSize;}

	void UpdateWrite(int32 size) {TheBuffer->UpdateWrite(size);}
	MachWord * GetWritePtr() const  {return TheBuffer->GetWritePtr();}
	MachWord * GetWriteBase() const {return TheBuffer->GetBase();}
	MachWord * GetWriteEnd() const {return TheBuffer->GetEnd();}
	void WriteWord(MachWord Data) {TheBuffer->WriteWord(Data);}

	UnsignedIntegerMachWord * GetBinWritePtr() const
		{return TheBuffer->GetBinWritePtr();}
	UnsignedIntegerMachWord * GetBinWriteBase() const 
		{return TheBuffer->GetBinBase();}
	UnsignedIntegerMachWord * GetBinWriteEnd() const 
		{return TheBuffer->GetBinEnd();}

	void WriteBinary(UnsignedIntegerMachWord Data) {TheBuffer->WriteBinary(Data);}

	int32 GetSpace() const ;
	int32 GetContiguousSpace() const
		{return TheBuffer->GetContiguousAvailableSpace();}
	void WriteCxWord(CxMachWord Data) {TheBuffer->WriteCxWord(Data);}
	int GetNodeOutputChannel() const {return Channel;}
	int32 GetIncrementOut() {return IncrementOut;}
	int32 GetDynamicCount() const ;
	ErrCode Reset();
};


#endif /* #ifdef NETLNK_DOT_H */
