/*
 *  strmstr.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/*  strmstr.h   */
/*  Copyright 1990 Mountain Math Software  */
/*  All Rights Reserved                    */
#ifndef STRMSTR_DOT_H
#define STRMSTR_DOT_H
#include "ObjProGen/errcode.h"
#include "ObjProDSP/portable.h"
#include "ObjProDSP/arthtyp.h"
class DfNode ;


// ElementSize and BlockSize are set to NotInitialized if they need to be set
// to different values for different channels and thus cannot
// be set in the DfNode constructor.
// They are set to SizeVariable if they can assume a range of values
// consistent with their input. Most commonly ElementSize is allowed
// to be either one or two for nodes that support either real or complex
// input. The most common use for BlockSize is with output of the FFT.
// For example this parameter allows a plot node to automatically adjust
// for a linear time series or a time series of spectra of any size.

const SizeNotInitialized = -1 ;
const SizeVariable = 0 ;
class NodeOutChannelHeader;

class StreamStr {
	ArithType::ArithCapabilities StreamArithType ;
	int32 ElementSize ;
	int32 BlockSize ;
	double MinimumX ;
	double MaximumX ;
	double SampleRateFactor ;
public:
	enum CheckStream {CheckStreamError,CheckStreamNoChange,CheckStreamOk};

	StreamStr(const StreamStr& Str) ;
	StreamStr(int32 EltSz, int32 BlkSz, ArithType::ArithTypes type) ;
	StreamStr(int32 EltSz, int32 BlkSz, ArithType::ArithCapabilities type) ;
	StreamStr(int32 EltSz=SizeNotInitialized, int32 BlkSz=
		SizeNotInitialized, double MinX=0.0, double MaxX = 0.0,
		double sample_rate_factor=1.0,
		ArithType::ArithCapabilities type=
			(ArithType::ArithCapabilities)
			ArithType::ArithTypeUndefined) ;
	StreamStr(ArithType::ArithCapabilities type, int32 EltSz=SizeNotInitialized,
			int32 BlkSz= SizeNotInitialized, double MinX=0.0, double MaxX = 0.0,
        	double sample_rate_factor=1.0);
	virtual ~StreamStr();
	int Set(int32 EltSz=1, int32 BlkSz=1, double MinX=0.0, double MaxX=0.0,
		double sample_rate_factor=1.0,
		ArithType::ArithCapabilities type=
		(ArithType::ArithCapabilities) ArithType::ArithTypeUndefined);

	// The following base functions generate an error
	//     if conformance is not exact

	virtual int CheckInitialized() const ;
	virtual int CheckSet() const ;
	virtual int Set(StreamStr&);
	virtual CheckStream CheckInput(const StreamStr* Input);
	// Return values for CheckInitialized, CheckSet, Set and CheckInput:
	// Returns 1 on error - be sure and report node in which error occurs
	// Returns 0 on no error

	virtual CheckStream AdjustInput (const StreamStr * Input);

	ArithType::ArithCapabilities GetArithType() const {return 
		StreamArithType;}
	void SetArithType(ArithType::ArithCapabilities type)
		{StreamArithType = type;}
	void SetArithType(ArithType::ArithTypes type)
		{StreamArithType = (ArithType::ArithCapabilities) type;}
	ErrCode CheckArithType(const StreamStr& CheckAgainst) const ;
	ErrCode CheckReportArithType(const StreamStr& CheckAgainst,
		DfNode * in_node, int in_index) const ;
	int32 GetElementSize() const {return ElementSize;}
	int32 GetBlockSize() const {return BlockSize;}
	double GetMinimumX()const {return MinimumX;}
	double GetMaximumX()const {return MaximumX;}
	double GetSampleRateFactor()const {return SampleRateFactor;}
	virtual int32 GetChunkSize() const ;
	void SetFromDisk(const NodeOutChannelHeader& DiskState);
	void InitArithType(ArithType::ArithTypes type)
	   {if (StreamArithType == ArithType::ArithTypeUndefined)
		StreamArithType = (ArithType::ArithCapabilities) type;}
	void InitArithType(ArithType::ArithCapabilities type)
	   {if (StreamArithType == ArithType::ArithTypeUndefined)
		StreamArithType = (ArithType::ArithCapabilities)type;}
	virtual void dump(const char * msg=0) const ; // for debugging
};

class ElementStreamStr: public StreamStr {
public:
	ElementStreamStr( int32 EltSz=SizeNotInitialized,
		int32 BlkSz=SizeNotInitialized) ;
	virtual ~ElementStreamStr();
	virtual int32 GetChunkSize() const {return GetElementSize();}
};

extern const StreamStr StreamNotInitialized ;
extern const StreamStr StreamNotSet ;
extern const StreamStr StreamReal ;
extern const StreamStr StreamComplex ;

#endif /* #ifdef STRMSTR_DOT_H */
