/*
 *  mktarget.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/*  mktarget.h   */
/*  Copyright 1990 Mountain Math Software  */
/*  All Rights Reserved                    */

#include <stream.h>
#include <fstream.h>
#include "ObjProGen/outtok.h"
#include "ObjProNet/dfnode.h"


class ostream ;
class ProcessNet ;
class SharedArray ;

class EmitTargetCode {
	ostream& Out ;
	ostream& HeadOut ;
	ostream& NodeList ;
	OutTokens& OutTok ;
	ProcessNet& Net ;
	const char * OutName ;
	const char * HeadName ;
	const char * NodesName ;
	const char * StateName ;
	int GoodState ;
	SharedArray * TheSharedArrays ;
	TraverseObject& Object ;
public:
	EmitTargetCode(const char * out_name, const char * head_name,
		const char * nodes_name,ProcessNet& net, const char * dir_name,
		const char * state_name = "TheNetworkState",
		SharedArray *SharedArrays=0);
	~EmitTargetCode();
	void WriteKernelNodes();
	void WriteTargetState();
	int IsGood() { return GoodState;}
	void SetBadState() {GoodState=0;}
	const char * GetOutName() const { return OutName;}
	const char * GetHeadName() const { return HeadName;}
	const char * GetNodesName() const { return NodesName;}
	ostream& GetNodeList() const {return NodeList;}
	SharedArray * GetSharedArray() const {return TheSharedArrays;}
};
	
ofstream& CreateTargetFile(const char * Directory, const char * Name) ;

