/*
 *  circbufc.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/*  circbufc.h   */
/*  Copyright 1991 Mountain Math Software  */
/*  All Rights Reserved                    */
#include "ObjProGui/travparm.h"
#include "ObjProGui/bufstat.h"
#include "ObjProComGui/cgidbg.h"

void CircBufDes::AssignToEdit()
{
	assign_to_net_graph();
}

BufferStatus * CircBufDes::GetBufferStatus()
{
	// LogOut << "CircBufDes::GetBufferStatus\n" ;
	// LogOut << "GetTargetSize = " << GetTargetSize() << "\n" ;
	// LogOut << "GetMaxTargetSize = " << GetMaxTargetSize() << "\n" ;
	BufferStatus * Return = 0;
	Return = new BufferStatus(GetTargetSize(), GetMaxTargetSize(),
		GetMinTargetSize(),
		GetTargetControlGoal()==1 ? BufferStatus::FixedSequence:
		BufferStatus::ExistingSize,
		GetTargetSizeGoal()==1 ? BufferStatus::DesiredSizeLowerBound:
		BufferStatus::DesiredSizeUpperBound);
/*
 *	LogOut << "Getting MinTargetSize(" << GetMinTargetSize() <<
 *		") from buffer " << GetName() << "\n" ;
 */
	if (!Return) DbgError("CircBufDes::GetBufferStatus","new failure");
	return Return ;
}

void CircBufDesNodesInit() ;

CircBufDes::CircBufDes(const char * Name,int32 Size):
	BufferDescript(Name, CircBufferType,Size)
{
	CircBufDesNodesInit() ;
	InteractiveEntity * CircBf = AllEntityLists->GetInteractiveEntity(
		"CircBufDes");
	if (!CircBf) DbgError("CircBufDesCircBufDes::ctor","bad interactive");

	OneParameter * Temp = CircBf->GetOneParameter("TargetSize");
	SetTargetSize(Temp->IntP->Default);

	Temp = CircBf->GetOneParameter("MaxTargetSize");
	if (!Temp) goto Error ;
	SetMaxTargetSize(Temp->IntP->Default);

	Temp = CircBf->GetOneParameter("MinTargetSize");
	if (!Temp) goto Error ;
	int32 MinSize ;
	SetMinTargetSize(MinSize = Temp->IntP->Default);
/*
 *	LogOut << "MinTargetSize = " << MinSize << " in buffer " <<
 *		GetName() << "\n" ;
 */

	Temp = CircBf->GetOneParameter("TargetControlGoal");
	if (!Temp) goto Error ;
	SetTargetControlGoal(Temp->IntP->Default);

	Temp = CircBf->GetOneParameter("TargetSizeGoal");
	if (!Temp) goto Error ;
	SetTargetSizeGoal(Temp->IntP->Default);
	return ;
Error:
	DbgError("CircBufDesCircBufDes::ctor","bad parameter");

/*
 *	SetTargetSize(512);
 *	SetMaxTargetSize(4096);
 *	SetMinTargetSize(512);
 *	SetTargetControlGoal(1);
 *	SetTargetSizeGoal(0);
 */
}


